/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.DashboardGadgetPosition;

@ApiModel(description="Details of the settings for a dashboard gadget.")
public class DashboardGadgetSettings {
    @JsonProperty(value="color")
    private String color;
    @JsonProperty(value="ignoreUriAndModuleKeyValidation")
    private Boolean ignoreUriAndModuleKeyValidation;
    @JsonProperty(value="moduleKey")
    private String moduleKey;
    @JsonProperty(value="position")
    private DashboardGadgetPosition position;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="uri")
    private String uri;

    public DashboardGadgetSettings color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public DashboardGadgetSettings ignoreUriAndModuleKeyValidation(Boolean ignoreUriAndModuleKeyValidation) {
        this.ignoreUriAndModuleKeyValidation = ignoreUriAndModuleKeyValidation;
        return this;
    }

    @ApiModelProperty(value="Whether to ignore the validation of module key and URI. For example, when a gadget is created that is a part of an application that isn't installed.")
    public Boolean getIgnoreUriAndModuleKeyValidation() {
        return this.ignoreUriAndModuleKeyValidation;
    }

    public void setIgnoreUriAndModuleKeyValidation(Boolean ignoreUriAndModuleKeyValidation) {
        this.ignoreUriAndModuleKeyValidation = ignoreUriAndModuleKeyValidation;
    }

    public DashboardGadgetSettings moduleKey(String moduleKey) {
        this.moduleKey = moduleKey;
        return this;
    }

    @ApiModelProperty(value="The module key of the gadget type. Can't be provided with `uri`.")
    public String getModuleKey() {
        return this.moduleKey;
    }

    public void setModuleKey(String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public DashboardGadgetSettings position(DashboardGadgetPosition position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="The position of the gadget. When the gadget is placed into the position, other gadgets in the same column are moved down to accommodate it.")
    public DashboardGadgetPosition getPosition() {
        return this.position;
    }

    public void setPosition(DashboardGadgetPosition position) {
        this.position = position;
    }

    public DashboardGadgetSettings title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="The title of the gadget.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DashboardGadgetSettings uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="The URI of the gadget type. Can't be provided with `moduleKey`.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardGadgetSettings dashboardGadgetSettings = (DashboardGadgetSettings)o;
        return Objects.equals(this.color, dashboardGadgetSettings.color) && Objects.equals(this.ignoreUriAndModuleKeyValidation, dashboardGadgetSettings.ignoreUriAndModuleKeyValidation) && Objects.equals(this.moduleKey, dashboardGadgetSettings.moduleKey) && Objects.equals(this.position, dashboardGadgetSettings.position) && Objects.equals(this.title, dashboardGadgetSettings.title) && Objects.equals(this.uri, dashboardGadgetSettings.uri);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.ignoreUriAndModuleKeyValidation, this.moduleKey, this.position, this.title, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardGadgetSettings {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    ignoreUriAndModuleKeyValidation: ").append(this.toIndentedString(this.ignoreUriAndModuleKeyValidation)).append("\n");
        sb.append("    moduleKey: ").append(this.toIndentedString(this.moduleKey)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

