/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The details of a custom field context.")
public class CustomFieldContext {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="isAnyIssueType")
    private Boolean isAnyIssueType;
    @JsonProperty(value="isGlobalContext")
    private Boolean isGlobalContext;
    @JsonProperty(value="name")
    private String name;

    public CustomFieldContext description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the context.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CustomFieldContext id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the context.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CustomFieldContext isAnyIssueType(Boolean isAnyIssueType) {
        this.isAnyIssueType = isAnyIssueType;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the context apply to all issue types.")
    public Boolean getIsAnyIssueType() {
        return this.isAnyIssueType;
    }

    public void setIsAnyIssueType(Boolean isAnyIssueType) {
        this.isAnyIssueType = isAnyIssueType;
    }

    public CustomFieldContext isGlobalContext(Boolean isGlobalContext) {
        this.isGlobalContext = isGlobalContext;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the context is global.")
    public Boolean getIsGlobalContext() {
        return this.isGlobalContext;
    }

    public void setIsGlobalContext(Boolean isGlobalContext) {
        this.isGlobalContext = isGlobalContext;
    }

    public CustomFieldContext name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the context.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldContext customFieldContext = (CustomFieldContext)o;
        return Objects.equals(this.description, customFieldContext.description) && Objects.equals(this.id, customFieldContext.id) && Objects.equals(this.isAnyIssueType, customFieldContext.isAnyIssueType) && Objects.equals(this.isGlobalContext, customFieldContext.isGlobalContext) && Objects.equals(this.name, customFieldContext.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.isAnyIssueType, this.isGlobalContext, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomFieldContext {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isAnyIssueType: ").append(this.toIndentedString(this.isAnyIssueType)).append("\n");
        sb.append("    isGlobalContext: ").append(this.toIndentedString(this.isGlobalContext)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

