/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of an issue priority.")
public class CreatePriorityDetails {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="iconUrl")
    private IconUrlEnum iconUrl;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="statusColor")
    private String statusColor;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public CreatePriorityDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the priority.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePriorityDetails iconUrl(IconUrlEnum iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used.")
    public IconUrlEnum getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(IconUrlEnum iconUrl) {
        this.iconUrl = iconUrl;
    }

    public CreatePriorityDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the priority. Must be unique.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreatePriorityDetails statusColor(String statusColor) {
        this.statusColor = statusColor;
        return this;
    }

    @ApiModelProperty(required=true, value="The status color of the priority in 3-digit or 6-digit hexadecimal format.")
    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePriorityDetails createPriorityDetails = (CreatePriorityDetails)o;
        return Objects.equals(this.description, createPriorityDetails.description) && Objects.equals((Object)this.iconUrl, (Object)createPriorityDetails.iconUrl) && Objects.equals(this.name, createPriorityDetails.name) && Objects.equals(this.statusColor, createPriorityDetails.statusColor) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.iconUrl, this.name, this.statusColor, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePriorityDetails {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString((Object)this.iconUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statusColor: ").append(this.toIndentedString(this.statusColor)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IconUrlEnum {
        BLOCKER_PNG("/images/icons/priorities/blocker.png"),
        CRITICAL_PNG("/images/icons/priorities/critical.png"),
        HIGH_PNG("/images/icons/priorities/high.png"),
        HIGHEST_PNG("/images/icons/priorities/highest.png"),
        LOW_PNG("/images/icons/priorities/low.png"),
        LOWEST_PNG("/images/icons/priorities/lowest.png"),
        MAJOR_PNG("/images/icons/priorities/major.png"),
        MEDIUM_PNG("/images/icons/priorities/medium.png"),
        MINOR_PNG("/images/icons/priorities/minor.png"),
        TRIVIAL_PNG("/images/icons/priorities/trivial.png");

        private String value;

        private IconUrlEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IconUrlEnum fromValue(String value) {
            for (IconUrlEnum b : IconUrlEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

