/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of project permissions and associated issues and projects to look up.")
public class BulkProjectPermissions {
    @JsonProperty(value="issues")
    private List<Long> issues = new ArrayList<Long>();
    @JsonProperty(value="permissions")
    private List<String> permissions = new ArrayList<String>();
    @JsonProperty(value="projects")
    private List<Long> projects = new ArrayList<Long>();

    public BulkProjectPermissions issues(List<Long> issues) {
        this.issues = issues;
        return this;
    }

    public BulkProjectPermissions addIssuesItem(Long issuesItem) {
        if (this.issues == null) {
            this.issues = new ArrayList<Long>();
        }
        this.issues.add(issuesItem);
        return this;
    }

    @ApiModelProperty(value="List of issue IDs.")
    public List<Long> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Long> issues) {
        this.issues = issues;
    }

    public BulkProjectPermissions permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public BulkProjectPermissions addPermissionsItem(String permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of project permissions.")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public BulkProjectPermissions projects(List<Long> projects) {
        this.projects = projects;
        return this;
    }

    public BulkProjectPermissions addProjectsItem(Long projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Long>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @ApiModelProperty(value="List of project IDs.")
    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkProjectPermissions bulkProjectPermissions = (BulkProjectPermissions)o;
        return Objects.equals(this.issues, bulkProjectPermissions.issues) && Objects.equals(this.permissions, bulkProjectPermissions.permissions) && Objects.equals(this.projects, bulkProjectPermissions.projects);
    }

    public int hashCode() {
        return Objects.hash(this.issues, this.permissions, this.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkProjectPermissions {\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

