/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkEditActionError;

@ApiModel(description="Details of a request to bulk edit shareable entity.")
public class BulkEditShareableEntityResponse {
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonProperty(value="entityErrors")
    private Map<String, BulkEditActionError> entityErrors = new HashMap<String, BulkEditActionError>();

    public BulkEditShareableEntityResponse action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="Allowed action for bulk edit shareable entity")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public BulkEditShareableEntityResponse entityErrors(Map<String, BulkEditActionError> entityErrors) {
        this.entityErrors = entityErrors;
        return this;
    }

    public BulkEditShareableEntityResponse putEntityErrorsItem(String key, BulkEditActionError entityErrorsItem) {
        if (this.entityErrors == null) {
            this.entityErrors = new HashMap<String, BulkEditActionError>();
        }
        this.entityErrors.put(key, entityErrorsItem);
        return this;
    }

    @ApiModelProperty(value="The mapping dashboard id to errors if any.")
    public Map<String, BulkEditActionError> getEntityErrors() {
        return this.entityErrors;
    }

    public void setEntityErrors(Map<String, BulkEditActionError> entityErrors) {
        this.entityErrors = entityErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkEditShareableEntityResponse bulkEditShareableEntityResponse = (BulkEditShareableEntityResponse)o;
        return Objects.equals((Object)this.action, (Object)bulkEditShareableEntityResponse.action) && Objects.equals(this.entityErrors, bulkEditShareableEntityResponse.entityErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.entityErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkEditShareableEntityResponse {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    entityErrors: ").append(this.toIndentedString(this.entityErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        CHANGEOWNER("changeOwner"),
        CHANGEPERMISSION("changePermission"),
        ADDPERMISSION("addPermission"),
        REMOVEPERMISSION("removePermission");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

