/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The Forge provided ecosystem rules available.")
public class AvailableWorkflowForgeRule {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="ruleKey")
    private String ruleKey;
    @JsonProperty(value="ruleType")
    private RuleTypeEnum ruleType;

    public AvailableWorkflowForgeRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The rule description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AvailableWorkflowForgeRule id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique ARI of the forge rule type.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AvailableWorkflowForgeRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The rule name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AvailableWorkflowForgeRule ruleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @ApiModelProperty(value="The rule key.")
    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public AvailableWorkflowForgeRule ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @ApiModelProperty(value="The rule type.")
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableWorkflowForgeRule availableWorkflowForgeRule = (AvailableWorkflowForgeRule)o;
        return Objects.equals(this.description, availableWorkflowForgeRule.description) && Objects.equals(this.id, availableWorkflowForgeRule.id) && Objects.equals(this.name, availableWorkflowForgeRule.name) && Objects.equals(this.ruleKey, availableWorkflowForgeRule.ruleKey) && Objects.equals((Object)this.ruleType, (Object)availableWorkflowForgeRule.ruleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.id, this.name, this.ruleKey, this.ruleType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableWorkflowForgeRule {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ruleKey: ").append(this.toIndentedString(this.ruleKey)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RuleTypeEnum {
        CONDITION("Condition"),
        VALIDATOR("Validator"),
        FUNCTION("Function"),
        SCREEN("Screen");

        private String value;

        private RuleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RuleTypeEnum fromValue(String value) {
            for (RuleTypeEnum b : RuleTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

