/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.DateRangeFilterRequest;

@ApiModel(description="Details of a filter for exporting archived issues.")
public class ArchivedIssuesFilterRequest {
    @JsonProperty(value="archivedBy")
    private List<String> archivedBy = new ArrayList<String>();
    @JsonProperty(value="archivedDateRange")
    private DateRangeFilterRequest archivedDateRange;
    @JsonProperty(value="issueTypes")
    private List<String> issueTypes = new ArrayList<String>();
    @JsonProperty(value="projects")
    private List<String> projects = new ArrayList<String>();
    @JsonProperty(value="reporters")
    private List<String> reporters = new ArrayList<String>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public ArchivedIssuesFilterRequest archivedBy(List<String> archivedBy) {
        this.archivedBy = archivedBy;
        return this;
    }

    public ArchivedIssuesFilterRequest addArchivedByItem(String archivedByItem) {
        if (this.archivedBy == null) {
            this.archivedBy = new ArrayList<String>();
        }
        this.archivedBy.add(archivedByItem);
        return this;
    }

    @ApiModelProperty(value="List archived issues archived by a specified account ID.")
    public List<String> getArchivedBy() {
        return this.archivedBy;
    }

    public void setArchivedBy(List<String> archivedBy) {
        this.archivedBy = archivedBy;
    }

    public ArchivedIssuesFilterRequest archivedDateRange(DateRangeFilterRequest archivedDateRange) {
        this.archivedDateRange = archivedDateRange;
        return this;
    }

    @ApiModelProperty(value="")
    public DateRangeFilterRequest getArchivedDateRange() {
        return this.archivedDateRange;
    }

    public void setArchivedDateRange(DateRangeFilterRequest archivedDateRange) {
        this.archivedDateRange = archivedDateRange;
    }

    public ArchivedIssuesFilterRequest issueTypes(List<String> issueTypes) {
        this.issueTypes = issueTypes;
        return this;
    }

    public ArchivedIssuesFilterRequest addIssueTypesItem(String issueTypesItem) {
        if (this.issueTypes == null) {
            this.issueTypes = new ArrayList<String>();
        }
        this.issueTypes.add(issueTypesItem);
        return this;
    }

    @ApiModelProperty(value="List archived issues with a specified issue type ID.")
    public List<String> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(List<String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public ArchivedIssuesFilterRequest projects(List<String> projects) {
        this.projects = projects;
        return this;
    }

    public ArchivedIssuesFilterRequest addProjectsItem(String projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<String>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @ApiModelProperty(value="List archived issues with a specified project key.")
    public List<String> getProjects() {
        return this.projects;
    }

    public void setProjects(List<String> projects) {
        this.projects = projects;
    }

    public ArchivedIssuesFilterRequest reporters(List<String> reporters) {
        this.reporters = reporters;
        return this;
    }

    public ArchivedIssuesFilterRequest addReportersItem(String reportersItem) {
        if (this.reporters == null) {
            this.reporters = new ArrayList<String>();
        }
        this.reporters.add(reportersItem);
        return this;
    }

    @ApiModelProperty(value="List archived issues where the reporter is a specified account ID.")
    public List<String> getReporters() {
        return this.reporters;
    }

    public void setReporters(List<String> reporters) {
        this.reporters = reporters;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedIssuesFilterRequest archivedIssuesFilterRequest = (ArchivedIssuesFilterRequest)o;
        return Objects.equals(this.archivedBy, archivedIssuesFilterRequest.archivedBy) && Objects.equals(this.archivedDateRange, archivedIssuesFilterRequest.archivedDateRange) && Objects.equals(this.issueTypes, archivedIssuesFilterRequest.issueTypes) && Objects.equals(this.projects, archivedIssuesFilterRequest.projects) && Objects.equals(this.reporters, archivedIssuesFilterRequest.reporters) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.archivedBy, this.archivedDateRange, this.issueTypes, this.projects, this.reporters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchivedIssuesFilterRequest {\n");
        sb.append("    archivedBy: ").append(this.toIndentedString(this.archivedBy)).append("\n");
        sb.append("    archivedDateRange: ").append(this.toIndentedString(this.archivedDateRange)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    reporters: ").append(this.toIndentedString(this.reporters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

