/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.GroupName;

@ApiModel(description="Details of an application role.")
public class ApplicationRole {
    @JsonProperty(value="defaultGroups")
    private List<String> defaultGroups = new ArrayList<String>();
    @JsonProperty(value="defaultGroupsDetails")
    private List<GroupName> defaultGroupsDetails = new ArrayList<GroupName>();
    @JsonProperty(value="defined")
    private Boolean defined;
    @JsonProperty(value="groupDetails")
    private List<GroupName> groupDetails = new ArrayList<GroupName>();
    @JsonProperty(value="groups")
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="hasUnlimitedSeats")
    private Boolean hasUnlimitedSeats;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="numberOfSeats")
    private Integer numberOfSeats;
    @JsonProperty(value="platform")
    private Boolean platform;
    @JsonProperty(value="remainingSeats")
    private Integer remainingSeats;
    @JsonProperty(value="selectedByDefault")
    private Boolean selectedByDefault;
    @JsonProperty(value="userCount")
    private Integer userCount;
    @JsonProperty(value="userCountDescription")
    private String userCountDescription;

    public ApplicationRole defaultGroups(List<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
        return this;
    }

    public ApplicationRole addDefaultGroupsItem(String defaultGroupsItem) {
        if (this.defaultGroups == null) {
            this.defaultGroups = new ArrayList<String>();
        }
        this.defaultGroups.add(defaultGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The groups that are granted default access for this application role. As a group's name can change, use of `defaultGroupsDetails` is recommended to identify a groups.")
    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public void setDefaultGroups(List<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public ApplicationRole defaultGroupsDetails(List<GroupName> defaultGroupsDetails) {
        this.defaultGroupsDetails = defaultGroupsDetails;
        return this;
    }

    public ApplicationRole addDefaultGroupsDetailsItem(GroupName defaultGroupsDetailsItem) {
        if (this.defaultGroupsDetails == null) {
            this.defaultGroupsDetails = new ArrayList<GroupName>();
        }
        this.defaultGroupsDetails.add(defaultGroupsDetailsItem);
        return this;
    }

    @ApiModelProperty(value="The groups that are granted default access for this application role.")
    public List<GroupName> getDefaultGroupsDetails() {
        return this.defaultGroupsDetails;
    }

    public void setDefaultGroupsDetails(List<GroupName> defaultGroupsDetails) {
        this.defaultGroupsDetails = defaultGroupsDetails;
    }

    public ApplicationRole defined(Boolean defined) {
        this.defined = defined;
        return this;
    }

    @ApiModelProperty(value="Deprecated.")
    public Boolean getDefined() {
        return this.defined;
    }

    public void setDefined(Boolean defined) {
        this.defined = defined;
    }

    public ApplicationRole groupDetails(List<GroupName> groupDetails) {
        this.groupDetails = groupDetails;
        return this;
    }

    public ApplicationRole addGroupDetailsItem(GroupName groupDetailsItem) {
        if (this.groupDetails == null) {
            this.groupDetails = new ArrayList<GroupName>();
        }
        this.groupDetails.add(groupDetailsItem);
        return this;
    }

    @ApiModelProperty(value="The groups associated with the application role.")
    public List<GroupName> getGroupDetails() {
        return this.groupDetails;
    }

    public void setGroupDetails(List<GroupName> groupDetails) {
        this.groupDetails = groupDetails;
    }

    public ApplicationRole groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public ApplicationRole addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="The groups associated with the application role. As a group's name can change, use of `groupDetails` is recommended to identify a groups.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public ApplicationRole hasUnlimitedSeats(Boolean hasUnlimitedSeats) {
        this.hasUnlimitedSeats = hasUnlimitedSeats;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getHasUnlimitedSeats() {
        return this.hasUnlimitedSeats;
    }

    public void setHasUnlimitedSeats(Boolean hasUnlimitedSeats) {
        this.hasUnlimitedSeats = hasUnlimitedSeats;
    }

    public ApplicationRole key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of the application role.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApplicationRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The display name of the application role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationRole numberOfSeats(Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
        return this;
    }

    @ApiModelProperty(value="The maximum count of users on your license.")
    public Integer getNumberOfSeats() {
        return this.numberOfSeats;
    }

    public void setNumberOfSeats(Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
    }

    public ApplicationRole platform(Boolean platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(value="Indicates if the application role belongs to Jira platform (`jira-core`).")
    public Boolean getPlatform() {
        return this.platform;
    }

    public void setPlatform(Boolean platform) {
        this.platform = platform;
    }

    public ApplicationRole remainingSeats(Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
        return this;
    }

    @ApiModelProperty(value="The count of users remaining on your license.")
    public Integer getRemainingSeats() {
        return this.remainingSeats;
    }

    public void setRemainingSeats(Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
    }

    public ApplicationRole selectedByDefault(Boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
        return this;
    }

    @ApiModelProperty(value="Determines whether this application role should be selected by default on user creation.")
    public Boolean getSelectedByDefault() {
        return this.selectedByDefault;
    }

    public void setSelectedByDefault(Boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
    }

    public ApplicationRole userCount(Integer userCount) {
        this.userCount = userCount;
        return this;
    }

    @ApiModelProperty(value="The number of users counting against your license.")
    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public ApplicationRole userCountDescription(String userCountDescription) {
        this.userCountDescription = userCountDescription;
        return this;
    }

    @ApiModelProperty(value="The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.")
    public String getUserCountDescription() {
        return this.userCountDescription;
    }

    public void setUserCountDescription(String userCountDescription) {
        this.userCountDescription = userCountDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRole applicationRole = (ApplicationRole)o;
        return Objects.equals(this.defaultGroups, applicationRole.defaultGroups) && Objects.equals(this.defaultGroupsDetails, applicationRole.defaultGroupsDetails) && Objects.equals(this.defined, applicationRole.defined) && Objects.equals(this.groupDetails, applicationRole.groupDetails) && Objects.equals(this.groups, applicationRole.groups) && Objects.equals(this.hasUnlimitedSeats, applicationRole.hasUnlimitedSeats) && Objects.equals(this.key, applicationRole.key) && Objects.equals(this.name, applicationRole.name) && Objects.equals(this.numberOfSeats, applicationRole.numberOfSeats) && Objects.equals(this.platform, applicationRole.platform) && Objects.equals(this.remainingSeats, applicationRole.remainingSeats) && Objects.equals(this.selectedByDefault, applicationRole.selectedByDefault) && Objects.equals(this.userCount, applicationRole.userCount) && Objects.equals(this.userCountDescription, applicationRole.userCountDescription);
    }

    public int hashCode() {
        return Objects.hash(this.defaultGroups, this.defaultGroupsDetails, this.defined, this.groupDetails, this.groups, this.hasUnlimitedSeats, this.key, this.name, this.numberOfSeats, this.platform, this.remainingSeats, this.selectedByDefault, this.userCount, this.userCountDescription);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationRole {\n");
        sb.append("    defaultGroups: ").append(this.toIndentedString(this.defaultGroups)).append("\n");
        sb.append("    defaultGroupsDetails: ").append(this.toIndentedString(this.defaultGroupsDetails)).append("\n");
        sb.append("    defined: ").append(this.toIndentedString(this.defined)).append("\n");
        sb.append("    groupDetails: ").append(this.toIndentedString(this.groupDetails)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    hasUnlimitedSeats: ").append(this.toIndentedString(this.hasUnlimitedSeats)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numberOfSeats: ").append(this.toIndentedString(this.numberOfSeats)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    remainingSeats: ").append(this.toIndentedString(this.remainingSeats)).append("\n");
        sb.append("    selectedByDefault: ").append(this.toIndentedString(this.selectedByDefault)).append("\n");
        sb.append("    userCount: ").append(this.toIndentedString(this.userCount)).append("\n");
        sb.append("    userCountDescription: ").append(this.toIndentedString(this.userCountDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

