/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateWorkflowDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.DeprecatedWorkflow;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanWorkflow;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowCapabilities;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowCreateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowCreateResponse;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowCreateValidateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowIDs;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowReadRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowReadResponse;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowUpdateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowUpdateResponse;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowUpdateValidateRequestBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowValidationErrorList;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class WorkflowsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<WorkflowIDs> returnType_createWorkflow = new TypeReference<WorkflowIDs>(){};
    private static final TypeReference<WorkflowCreateResponse> returnType_createWorkflows = new TypeReference<WorkflowCreateResponse>(){};
    private static final TypeReference<List<DeprecatedWorkflow>> returnType_getAllWorkflows = new TypeReference<List<DeprecatedWorkflow>>(){};
    private static final TypeReference<PageBeanWorkflow> returnType_getWorkflowsPaginated = new TypeReference<PageBeanWorkflow>(){};
    private static final TypeReference<WorkflowReadResponse> returnType_readWorkflows = new TypeReference<WorkflowReadResponse>(){};
    private static final TypeReference<WorkflowUpdateResponse> returnType_updateWorkflows = new TypeReference<WorkflowUpdateResponse>(){};
    private static final TypeReference<WorkflowValidationErrorList> returnType_validateCreateWorkflows = new TypeReference<WorkflowValidationErrorList>(){};
    private static final TypeReference<WorkflowValidationErrorList> returnType_validateUpdateWorkflows = new TypeReference<WorkflowValidationErrorList>(){};
    private static final TypeReference<WorkflowCapabilities> returnType_workflowCapabilities = new TypeReference<WorkflowCapabilities>(){};
    private final RestClient restClient;

    public WorkflowsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    @Deprecated
    public Single<WorkflowIDs> createWorkflow(CreateWorkflowDetails createWorkflowDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(createWorkflowDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createWorkflow);
    }

    public Single<WorkflowCreateResponse> createWorkflows(WorkflowCreateRequest workflowCreateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows/create");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowCreateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createWorkflows);
    }

    public Completable deleteInactiveWorkflow(String entityId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/{entityId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("entityId", String.valueOf(entityId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    @Deprecated
    public Single<List<DeprecatedWorkflow>> getAllWorkflows(Optional<String> workflowName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllWorkflows);
    }

    public Single<PageBeanWorkflow> getWorkflowsPaginated(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<String>> workflowName, Optional<String> expand, Optional<String> queryString, Optional<String> orderBy, Optional<Boolean> isActive, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", RestClientUtil.objectCollectionToStringCollection((Collection)workflowName.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (queryString.isPresent()) {
            queryParams.put("queryString", Collections.singleton(String.valueOf(queryString.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (isActive.isPresent()) {
            queryParams.put("isActive", Collections.singleton(String.valueOf(isActive.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowsPaginated);
    }

    public Single<WorkflowReadResponse> readWorkflows(WorkflowReadRequest workflowReadRequest, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowReadRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_readWorkflows);
    }

    public Single<WorkflowUpdateResponse> updateWorkflows(WorkflowUpdateRequest workflowUpdateRequest, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows/update");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowUpdateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflows);
    }

    public Single<WorkflowValidationErrorList> validateCreateWorkflows(WorkflowCreateValidateRequest workflowCreateValidateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows/create/validation");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowCreateValidateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_validateCreateWorkflows);
    }

    public Single<WorkflowValidationErrorList> validateUpdateWorkflows(WorkflowUpdateValidateRequestBean workflowUpdateValidateRequestBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows/update/validation");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowUpdateValidateRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_validateUpdateWorkflows);
    }

    public Single<WorkflowCapabilities> workflowCapabilities(Optional<String> workflowId, Optional<String> projectId, Optional<String> issueTypeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflows/capabilities");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowId.isPresent()) {
            queryParams.put("workflowId", Collections.singleton(String.valueOf(workflowId.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        if (issueTypeId.isPresent()) {
            queryParams.put("issueTypeId", Collections.singleton(String.valueOf(issueTypeId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_workflowCapabilities);
    }
}

