/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateUiModificationDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanUiModificationDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.UiModificationIdentifiers;
import org.everit.atlassian.restclient.jiracloud.v2.model.UpdateUiModificationDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class UiModificationsAppsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<UiModificationIdentifiers> returnType_createUiModification = new TypeReference<UiModificationIdentifiers>(){};
    private static final TypeReference<Object> returnType_deleteUiModification = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanUiModificationDetails> returnType_getUiModifications = new TypeReference<PageBeanUiModificationDetails>(){};
    private static final TypeReference<Object> returnType_updateUiModification = new TypeReference<Object>(){};
    private final RestClient restClient;

    public UiModificationsAppsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<UiModificationIdentifiers> createUiModification(CreateUiModificationDetails createUiModificationDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/uiModifications");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(createUiModificationDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createUiModification);
    }

    public Single<Object> deleteUiModification(String uiModificationId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/uiModifications/{uiModificationId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("uiModificationId", String.valueOf(uiModificationId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteUiModification);
    }

    public Single<PageBeanUiModificationDetails> getUiModifications(Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/uiModifications");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUiModifications);
    }

    public Single<Object> updateUiModification(String uiModificationId, UpdateUiModificationDetails updateUiModificationDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/uiModifications/{uiModificationId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("uiModificationId", String.valueOf(uiModificationId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(updateUiModificationDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateUiModification);
    }
}

