/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.JiraStatus;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageOfStatuses;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusCreateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusUpdateRequest;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class StatusApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<List<JiraStatus>> returnType_createStatuses = new TypeReference<List<JiraStatus>>(){};
    private static final TypeReference<Object> returnType_deleteStatusesById = new TypeReference<Object>(){};
    private static final TypeReference<List<JiraStatus>> returnType_getStatusesById = new TypeReference<List<JiraStatus>>(){};
    private static final TypeReference<PageOfStatuses> returnType_search = new TypeReference<PageOfStatuses>(){};
    private static final TypeReference<Object> returnType_updateStatuses = new TypeReference<Object>(){};
    private final RestClient restClient;

    public StatusApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<List<JiraStatus>> createStatuses(StatusCreateRequest statusCreateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/statuses");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(statusCreateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createStatuses);
    }

    public Single<Object> deleteStatusesById(Optional<List<String>> id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/statuses");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteStatusesById);
    }

    public Single<List<JiraStatus>> getStatusesById(Optional<String> expand, Optional<List<String>> id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/statuses");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getStatusesById);
    }

    public Single<PageOfStatuses> search(Optional<String> expand, Optional<String> projectId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> searchString, Optional<String> statusCategory, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/statuses/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (searchString.isPresent()) {
            queryParams.put("searchString", Collections.singleton(String.valueOf(searchString.get())));
        }
        if (statusCategory.isPresent()) {
            queryParams.put("statusCategory", Collections.singleton(String.valueOf(statusCategory.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_search);
    }

    public Single<Object> updateStatuses(StatusUpdateRequest statusUpdateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/statuses");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(statusUpdateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateStatuses);
    }
}

