/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanScreenScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenSchemeDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenSchemeId;
import org.everit.atlassian.restclient.jiracloud.v2.model.UpdateScreenSchemeDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ScreenSchemesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<ScreenSchemeId> returnType_createScreenScheme = new TypeReference<ScreenSchemeId>(){};
    private static final TypeReference<PageBeanScreenScheme> returnType_getScreenSchemes = new TypeReference<PageBeanScreenScheme>(){};
    private static final TypeReference<Object> returnType_updateScreenScheme = new TypeReference<Object>(){};
    private final RestClient restClient;

    public ScreenSchemesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ScreenSchemeId> createScreenScheme(ScreenSchemeDetails screenSchemeDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screenscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenSchemeDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createScreenScheme);
    }

    public Completable deleteScreenScheme(String screenSchemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screenscheme/{screenSchemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenSchemeId", String.valueOf(screenSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<PageBeanScreenScheme> getScreenSchemes(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> id, Optional<String> expand, Optional<String> queryString, Optional<String> orderBy, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screenscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (queryString.isPresent()) {
            queryParams.put("queryString", Collections.singleton(String.valueOf(queryString.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getScreenSchemes);
    }

    public Single<Object> updateScreenScheme(String screenSchemeId, UpdateScreenSchemeDetails updateScreenSchemeDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screenscheme/{screenSchemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenSchemeId", String.valueOf(screenSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(updateScreenSchemeDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateScreenScheme);
    }
}

