/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.AddSecuritySchemeLevelsRequestBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.AssociateSecuritySchemeWithProjectDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanIssueSecuritySchemeToProjectMapping;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanSecurityLevel;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanSecurityLevelMember;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanSecuritySchemeWithProjects;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecurityScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecuritySchemeId;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecuritySchemeMembersRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecuritySchemes;
import org.everit.atlassian.restclient.jiracloud.v2.model.UpdateIssueSecuritySchemeRequestBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueSecuritySchemesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_addSecurityLevel = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_addSecurityLevelMembers = new TypeReference<Object>(){};
    private static final TypeReference<SecuritySchemeId> returnType_createIssueSecurityScheme = new TypeReference<SecuritySchemeId>(){};
    private static final TypeReference<Object> returnType_deleteSecurityScheme = new TypeReference<Object>(){};
    private static final TypeReference<SecurityScheme> returnType_getIssueSecurityScheme = new TypeReference<SecurityScheme>(){};
    private static final TypeReference<SecuritySchemes> returnType_getIssueSecuritySchemes = new TypeReference<SecuritySchemes>(){};
    private static final TypeReference<PageBeanSecurityLevelMember> returnType_getSecurityLevelMembers = new TypeReference<PageBeanSecurityLevelMember>(){};
    private static final TypeReference<PageBeanSecurityLevel> returnType_getSecurityLevels = new TypeReference<PageBeanSecurityLevel>(){};
    private static final TypeReference<Object> returnType_removeMemberFromSecurityLevel = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanIssueSecuritySchemeToProjectMapping> returnType_searchProjectsUsingSecuritySchemes = new TypeReference<PageBeanIssueSecuritySchemeToProjectMapping>(){};
    private static final TypeReference<PageBeanSecuritySchemeWithProjects> returnType_searchSecuritySchemes = new TypeReference<PageBeanSecuritySchemeWithProjects>(){};
    private static final TypeReference<Object> returnType_setDefaultLevels = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateIssueSecurityScheme = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateSecurityLevel = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueSecuritySchemesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addSecurityLevel(String schemeId, AddSecuritySchemeLevelsRequestBean addSecuritySchemeLevelsRequestBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}/level");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(addSecuritySchemeLevelsRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addSecurityLevel);
    }

    public Single<Object> addSecurityLevelMembers(String schemeId, String levelId, SecuritySchemeMembersRequest securitySchemeMembersRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}/level/{levelId}/member");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("levelId", String.valueOf(levelId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(securitySchemeMembersRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addSecurityLevelMembers);
    }

    public Completable associateSchemesToProjects(AssociateSecuritySchemeWithProjectDetails associateSecuritySchemeWithProjectDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(associateSecuritySchemeWithProjectDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<SecuritySchemeId> createIssueSecurityScheme(Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueSecurityScheme);
    }

    public Single<Object> deleteSecurityScheme(String schemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteSecurityScheme);
    }

    public Single<SecurityScheme> getIssueSecurityScheme(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueSecurityScheme);
    }

    public Single<SecuritySchemes> getIssueSecuritySchemes(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueSecuritySchemes);
    }

    public Single<PageBeanSecurityLevelMember> getSecurityLevelMembers(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> id, Optional<List<String>> schemeId, Optional<List<String>> levelId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/level/member");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (schemeId.isPresent()) {
            queryParams.put("schemeId", RestClientUtil.objectCollectionToStringCollection((Collection)schemeId.get()));
        }
        if (levelId.isPresent()) {
            queryParams.put("levelId", RestClientUtil.objectCollectionToStringCollection((Collection)levelId.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getSecurityLevelMembers);
    }

    public Single<PageBeanSecurityLevel> getSecurityLevels(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> id, Optional<List<String>> schemeId, Optional<Boolean> onlyDefault, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/level");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (schemeId.isPresent()) {
            queryParams.put("schemeId", RestClientUtil.objectCollectionToStringCollection((Collection)schemeId.get()));
        }
        if (onlyDefault.isPresent()) {
            queryParams.put("onlyDefault", Collections.singleton(String.valueOf(onlyDefault.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getSecurityLevels);
    }

    public Completable removeLevel(String schemeId, String levelId, Optional<String> replaceWith, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}/level/{levelId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("levelId", String.valueOf(levelId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (replaceWith.isPresent()) {
            queryParams.put("replaceWith", Collections.singleton(String.valueOf(replaceWith.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Object> removeMemberFromSecurityLevel(String schemeId, String levelId, String memberId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}/level/{levelId}/member/{memberId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("levelId", String.valueOf(levelId));
        pathParams.put("memberId", String.valueOf(memberId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_removeMemberFromSecurityLevel);
    }

    public Single<PageBeanIssueSecuritySchemeToProjectMapping> searchProjectsUsingSecuritySchemes(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> issueSecuritySchemeId, Optional<List<String>> projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (issueSecuritySchemeId.isPresent()) {
            queryParams.put("issueSecuritySchemeId", RestClientUtil.objectCollectionToStringCollection((Collection)issueSecuritySchemeId.get()));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection((Collection)projectId.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchProjectsUsingSecuritySchemes);
    }

    public Single<PageBeanSecuritySchemeWithProjects> searchSecuritySchemes(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> id, Optional<List<String>> projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection((Collection)projectId.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchSecuritySchemes);
    }

    public Single<Object> setDefaultLevels(Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/level/default");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setDefaultLevels);
    }

    public Single<Object> updateIssueSecurityScheme(String id, UpdateIssueSecuritySchemeRequestBean updateIssueSecuritySchemeRequestBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(updateIssueSecuritySchemeRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateIssueSecurityScheme);
    }

    public Single<Object> updateSecurityLevel(String schemeId, String levelId, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{schemeId}/level/{levelId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("levelId", String.valueOf(levelId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateSecurityLevel);
    }
}

