/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanResolutionJsonBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.ReorderIssueResolutionsRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.Resolution;
import org.everit.atlassian.restclient.jiracloud.v2.model.ResolutionId;
import org.everit.atlassian.restclient.jiracloud.v2.model.SetDefaultResolutionRequest;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueResolutionsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<ResolutionId> returnType_createResolution = new TypeReference<ResolutionId>(){};
    private static final TypeReference<Resolution> returnType_getResolution = new TypeReference<Resolution>(){};
    private static final TypeReference<List<Resolution>> returnType_getResolutions = new TypeReference<List<Resolution>>(){};
    private static final TypeReference<Object> returnType_moveResolutions = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanResolutionJsonBean> returnType_searchResolutions = new TypeReference<PageBeanResolutionJsonBean>(){};
    private static final TypeReference<Object> returnType_setDefaultResolution = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateResolution = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueResolutionsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ResolutionId> createResolution(Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createResolution);
    }

    public Completable deleteResolution(String id, String replaceWith, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        queryParams.put("replaceWith", Collections.singleton(String.valueOf(replaceWith)));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Resolution> getResolution(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getResolution);
    }

    @Deprecated
    public Single<List<Resolution>> getResolutions(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getResolutions);
    }

    public Single<Object> moveResolutions(ReorderIssueResolutionsRequest reorderIssueResolutionsRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/move");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(reorderIssueResolutionsRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveResolutions);
    }

    public Single<PageBeanResolutionJsonBean> searchResolutions(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> id, Optional<Boolean> onlyDefault, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (onlyDefault.isPresent()) {
            queryParams.put("onlyDefault", Collections.singleton(String.valueOf(onlyDefault.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchResolutions);
    }

    public Single<Object> setDefaultResolution(SetDefaultResolutionRequest setDefaultResolutionRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/default");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(setDefaultResolutionRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setDefaultResolution);
    }

    public Single<Object> updateResolution(String id, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/resolution/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateResolution);
    }
}

