/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkCustomFieldOptionCreateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkCustomFieldOptionUpdateRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.CustomFieldCreatedContextOptionsList;
import org.everit.atlassian.restclient.jiracloud.v2.model.CustomFieldOption;
import org.everit.atlassian.restclient.jiracloud.v2.model.CustomFieldUpdatedContextOptionsList;
import org.everit.atlassian.restclient.jiracloud.v2.model.OrderOfCustomFieldOptions;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanCustomFieldContextOption;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueCustomFieldOptionsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<CustomFieldCreatedContextOptionsList> returnType_createCustomFieldOption = new TypeReference<CustomFieldCreatedContextOptionsList>(){};
    private static final TypeReference<CustomFieldOption> returnType_getCustomFieldOption = new TypeReference<CustomFieldOption>(){};
    private static final TypeReference<PageBeanCustomFieldContextOption> returnType_getOptionsForContext = new TypeReference<PageBeanCustomFieldContextOption>(){};
    private static final TypeReference<Object> returnType_reorderCustomFieldOptions = new TypeReference<Object>(){};
    private static final TypeReference<CustomFieldUpdatedContextOptionsList> returnType_updateCustomFieldOption = new TypeReference<CustomFieldUpdatedContextOptionsList>(){};
    private final RestClient restClient;

    public IssueCustomFieldOptionsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<CustomFieldCreatedContextOptionsList> createCustomFieldOption(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/context/{contextId}/option");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(bulkCustomFieldOptionCreateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createCustomFieldOption);
    }

    public Completable deleteCustomFieldOption(String fieldId, Long contextId, Long optionId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/context/{contextId}/option/{optionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        pathParams.put("optionId", String.valueOf(optionId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<CustomFieldOption> getCustomFieldOption(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/customFieldOption/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getCustomFieldOption);
    }

    public Single<PageBeanCustomFieldContextOption> getOptionsForContext(String fieldId, Long contextId, Optional<Long> optionId, Optional<Boolean> onlyOptions, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/context/{contextId}/option");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (optionId.isPresent()) {
            queryParams.put("optionId", Collections.singleton(String.valueOf(optionId.get())));
        }
        if (onlyOptions.isPresent()) {
            queryParams.put("onlyOptions", Collections.singleton(String.valueOf(onlyOptions.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getOptionsForContext);
    }

    public Single<Object> reorderCustomFieldOptions(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/context/{contextId}/option/move");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(orderOfCustomFieldOptions));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_reorderCustomFieldOptions);
    }

    public Single<CustomFieldUpdatedContextOptionsList> updateCustomFieldOption(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/context/{contextId}/option");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        pathParams.put("contextId", String.valueOf(contextId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(bulkCustomFieldOptionUpdateRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateCustomFieldOption);
    }
}

