/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.FoundGroups;
import org.everit.atlassian.restclient.jiracloud.v2.model.Group;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanGroupDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanUserDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class GroupsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Group> returnType_addUserToGroup = new TypeReference<Group>(){};
    private static final TypeReference<PageBeanGroupDetails> returnType_bulkGetGroups = new TypeReference<PageBeanGroupDetails>(){};
    private static final TypeReference<Group> returnType_createGroup = new TypeReference<Group>(){};
    private static final TypeReference<FoundGroups> returnType_findGroups = new TypeReference<FoundGroups>(){};
    private static final TypeReference<Group> returnType_getGroup = new TypeReference<Group>(){};
    private static final TypeReference<PageBeanUserDetails> returnType_getUsersFromGroup = new TypeReference<PageBeanUserDetails>(){};
    private final RestClient restClient;

    public GroupsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Group> addUserToGroup(Map<String, Object> requestBody, Optional<String> groupname, Optional<String> groupId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", Collections.singleton(String.valueOf(groupId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addUserToGroup);
    }

    public Single<PageBeanGroupDetails> bulkGetGroups(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<String>> groupId, Optional<List<String>> groupName, Optional<String> accessType, Optional<String> applicationKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group/bulk");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", RestClientUtil.objectCollectionToStringCollection((Collection)groupId.get()));
        }
        if (groupName.isPresent()) {
            queryParams.put("groupName", RestClientUtil.objectCollectionToStringCollection((Collection)groupName.get()));
        }
        if (accessType.isPresent()) {
            queryParams.put("accessType", Collections.singleton(String.valueOf(accessType.get())));
        }
        if (applicationKey.isPresent()) {
            queryParams.put("applicationKey", Collections.singleton(String.valueOf(applicationKey.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_bulkGetGroups);
    }

    public Single<Group> createGroup(Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createGroup);
    }

    public Single<FoundGroups> findGroups(Optional<String> accountId, Optional<String> query, Optional<List<String>> exclude, Optional<List<String>> excludeId, Optional<Integer> maxResults, Optional<Boolean> caseInsensitive, Optional<String> userName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/groups/picker");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (exclude.isPresent()) {
            queryParams.put("exclude", RestClientUtil.objectCollectionToStringCollection((Collection)exclude.get()));
        }
        if (excludeId.isPresent()) {
            queryParams.put("excludeId", RestClientUtil.objectCollectionToStringCollection((Collection)excludeId.get()));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (caseInsensitive.isPresent()) {
            queryParams.put("caseInsensitive", Collections.singleton(String.valueOf(caseInsensitive.get())));
        }
        if (userName.isPresent()) {
            queryParams.put("userName", Collections.singleton(String.valueOf(userName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findGroups);
    }

    @Deprecated
    public Single<Group> getGroup(Optional<String> groupname, Optional<String> groupId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", Collections.singleton(String.valueOf(groupId.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getGroup);
    }

    public Single<PageBeanUserDetails> getUsersFromGroup(Optional<String> groupname, Optional<String> groupId, Optional<Boolean> includeInactiveUsers, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group/member");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", Collections.singleton(String.valueOf(groupId.get())));
        }
        if (includeInactiveUsers.isPresent()) {
            queryParams.put("includeInactiveUsers", Collections.singleton(String.valueOf(includeInactiveUsers.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUsersFromGroup);
    }

    public Completable removeGroup(Optional<String> groupname, Optional<String> groupId, Optional<String> swapGroup, Optional<String> swapGroupId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", Collections.singleton(String.valueOf(groupId.get())));
        }
        if (swapGroup.isPresent()) {
            queryParams.put("swapGroup", Collections.singleton(String.valueOf(swapGroup.get())));
        }
        if (swapGroupId.isPresent()) {
            queryParams.put("swapGroupId", Collections.singleton(String.valueOf(swapGroupId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable removeUserFromGroup(String accountId, Optional<String> groupname, Optional<String> groupId, Optional<String> username, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/group/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (groupId.isPresent()) {
            queryParams.put("groupId", Collections.singleton(String.valueOf(groupId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        queryParams.put("accountId", Collections.singleton(String.valueOf(accountId)));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }
}

