/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v3.model.ConditionGroupConfiguration;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowRuleConfiguration;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowStatusAndPort;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowTrigger;

/**
 * The transitions of the workflow.
 */
@ApiModel(description = "The transitions of the workflow.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowTransitions {
  @JsonProperty("actions")
  private List<WorkflowRuleConfiguration> actions = new ArrayList<>();

  @JsonProperty("conditions")
  private ConditionGroupConfiguration conditions;

  @JsonProperty("customIssueEventId")
  private String customIssueEventId;

  @JsonProperty("description")
  private String description;

  @JsonProperty("from")
  private List<WorkflowStatusAndPort> from = new ArrayList<>();

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("properties")
  private Map<String, String> properties = new HashMap<>();

  @JsonProperty("to")
  private WorkflowStatusAndPort to;

  @JsonProperty("transitionScreen")
  private WorkflowRuleConfiguration transitionScreen;

  @JsonProperty("triggers")
  private List<WorkflowTrigger> triggers = new ArrayList<>();

  /**
   * The transition type.
   */
  public enum TypeEnum {
    INITIAL("INITIAL"),
    
    GLOBAL("GLOBAL"),
    
    DIRECTED("DIRECTED");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("validators")
  private List<WorkflowRuleConfiguration> validators = new ArrayList<>();

  public WorkflowTransitions actions(List<WorkflowRuleConfiguration> actions) {
    this.actions = actions;
    return this;
  }

  public WorkflowTransitions addActionsItem(WorkflowRuleConfiguration actionsItem) {
    if (this.actions == null) {
      this.actions = new ArrayList<>();
    }
    this.actions.add(actionsItem);
    return this;
  }

   /**
   * The post-functions of the transition.
   * @return actions
  **/
  @ApiModelProperty(value = "The post-functions of the transition.")
  public List<WorkflowRuleConfiguration> getActions() {
    return actions;
  }

  public void setActions(List<WorkflowRuleConfiguration> actions) {
    this.actions = actions;
  }

  public WorkflowTransitions conditions(ConditionGroupConfiguration conditions) {
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @ApiModelProperty(value = "")
  public ConditionGroupConfiguration getConditions() {
    return conditions;
  }

  public void setConditions(ConditionGroupConfiguration conditions) {
    this.conditions = conditions;
  }

  public WorkflowTransitions customIssueEventId(String customIssueEventId) {
    this.customIssueEventId = customIssueEventId;
    return this;
  }

   /**
   * The custom event ID of the transition.
   * @return customIssueEventId
  **/
  @ApiModelProperty(value = "The custom event ID of the transition.")
  public String getCustomIssueEventId() {
    return customIssueEventId;
  }

  public void setCustomIssueEventId(String customIssueEventId) {
    this.customIssueEventId = customIssueEventId;
  }

  public WorkflowTransitions description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the transition.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the transition.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WorkflowTransitions from(List<WorkflowStatusAndPort> from) {
    this.from = from;
    return this;
  }

  public WorkflowTransitions addFromItem(WorkflowStatusAndPort fromItem) {
    if (this.from == null) {
      this.from = new ArrayList<>();
    }
    this.from.add(fromItem);
    return this;
  }

   /**
   * The statuses the transition can start from.
   * @return from
  **/
  @ApiModelProperty(value = "The statuses the transition can start from.")
  public List<WorkflowStatusAndPort> getFrom() {
    return from;
  }

  public void setFrom(List<WorkflowStatusAndPort> from) {
    this.from = from;
  }

  public WorkflowTransitions id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the transition.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the transition.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WorkflowTransitions name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the transition.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the transition.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WorkflowTransitions properties(Map<String, String> properties) {
    this.properties = properties;
    return this;
  }

  public WorkflowTransitions putPropertiesItem(String key, String propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * The properties of the transition.
   * @return properties
  **/
  @ApiModelProperty(value = "The properties of the transition.")
  public Map<String, String> getProperties() {
    return properties;
  }

  public void setProperties(Map<String, String> properties) {
    this.properties = properties;
  }

  public WorkflowTransitions to(WorkflowStatusAndPort to) {
    this.to = to;
    return this;
  }

   /**
   * Get to
   * @return to
  **/
  @ApiModelProperty(value = "")
  public WorkflowStatusAndPort getTo() {
    return to;
  }

  public void setTo(WorkflowStatusAndPort to) {
    this.to = to;
  }

  public WorkflowTransitions transitionScreen(WorkflowRuleConfiguration transitionScreen) {
    this.transitionScreen = transitionScreen;
    return this;
  }

   /**
   * Get transitionScreen
   * @return transitionScreen
  **/
  @ApiModelProperty(value = "")
  public WorkflowRuleConfiguration getTransitionScreen() {
    return transitionScreen;
  }

  public void setTransitionScreen(WorkflowRuleConfiguration transitionScreen) {
    this.transitionScreen = transitionScreen;
  }

  public WorkflowTransitions triggers(List<WorkflowTrigger> triggers) {
    this.triggers = triggers;
    return this;
  }

  public WorkflowTransitions addTriggersItem(WorkflowTrigger triggersItem) {
    if (this.triggers == null) {
      this.triggers = new ArrayList<>();
    }
    this.triggers.add(triggersItem);
    return this;
  }

   /**
   * The triggers of the transition.
   * @return triggers
  **/
  @ApiModelProperty(value = "The triggers of the transition.")
  public List<WorkflowTrigger> getTriggers() {
    return triggers;
  }

  public void setTriggers(List<WorkflowTrigger> triggers) {
    this.triggers = triggers;
  }

  public WorkflowTransitions type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The transition type.
   * @return type
  **/
  @ApiModelProperty(value = "The transition type.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public WorkflowTransitions validators(List<WorkflowRuleConfiguration> validators) {
    this.validators = validators;
    return this;
  }

  public WorkflowTransitions addValidatorsItem(WorkflowRuleConfiguration validatorsItem) {
    if (this.validators == null) {
      this.validators = new ArrayList<>();
    }
    this.validators.add(validatorsItem);
    return this;
  }

   /**
   * The validators of the transition.
   * @return validators
  **/
  @ApiModelProperty(value = "The validators of the transition.")
  public List<WorkflowRuleConfiguration> getValidators() {
    return validators;
  }

  public void setValidators(List<WorkflowRuleConfiguration> validators) {
    this.validators = validators;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowTransitions workflowTransitions = (WorkflowTransitions) o;
    return Objects.equals(this.actions, workflowTransitions.actions) &&
        Objects.equals(this.conditions, workflowTransitions.conditions) &&
        Objects.equals(this.customIssueEventId, workflowTransitions.customIssueEventId) &&
        Objects.equals(this.description, workflowTransitions.description) &&
        Objects.equals(this.from, workflowTransitions.from) &&
        Objects.equals(this.id, workflowTransitions.id) &&
        Objects.equals(this.name, workflowTransitions.name) &&
        Objects.equals(this.properties, workflowTransitions.properties) &&
        Objects.equals(this.to, workflowTransitions.to) &&
        Objects.equals(this.transitionScreen, workflowTransitions.transitionScreen) &&
        Objects.equals(this.triggers, workflowTransitions.triggers) &&
        Objects.equals(this.type, workflowTransitions.type) &&
        Objects.equals(this.validators, workflowTransitions.validators);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actions, conditions, customIssueEventId, description, from, id, name, properties, to, transitionScreen, triggers, type, validators);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowTransitions {\n");
    
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    customIssueEventId: ").append(toIndentedString(customIssueEventId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    transitionScreen: ").append(toIndentedString(transitionScreen)).append("\n");
    sb.append("    triggers: ").append(toIndentedString(triggers)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validators: ").append(toIndentedString(validators)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

