/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.RequiredMappingByIssueType;
import org.everit.atlassian.restclient.jiracloud.v3.model.RequiredMappingByWorkflows;
import org.everit.atlassian.restclient.jiracloud.v3.model.StatusMetadata;
import org.everit.atlassian.restclient.jiracloud.v3.model.StatusesPerWorkflow;

/**
 * WorkflowSchemeUpdateRequiredMappingsResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowSchemeUpdateRequiredMappingsResponse {
  @JsonProperty("statusMappingsByIssueTypes")
  private List<RequiredMappingByIssueType> statusMappingsByIssueTypes = new ArrayList<>();

  @JsonProperty("statusMappingsByWorkflows")
  private List<RequiredMappingByWorkflows> statusMappingsByWorkflows = new ArrayList<>();

  @JsonProperty("statuses")
  private List<StatusMetadata> statuses = new ArrayList<>();

  @JsonProperty("statusesPerWorkflow")
  private List<StatusesPerWorkflow> statusesPerWorkflow = new ArrayList<>();

  public WorkflowSchemeUpdateRequiredMappingsResponse statusMappingsByIssueTypes(List<RequiredMappingByIssueType> statusMappingsByIssueTypes) {
    this.statusMappingsByIssueTypes = statusMappingsByIssueTypes;
    return this;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse addStatusMappingsByIssueTypesItem(RequiredMappingByIssueType statusMappingsByIssueTypesItem) {
    if (this.statusMappingsByIssueTypes == null) {
      this.statusMappingsByIssueTypes = new ArrayList<>();
    }
    this.statusMappingsByIssueTypes.add(statusMappingsByIssueTypesItem);
    return this;
  }

   /**
   * The list of required status mappings by issue type.
   * @return statusMappingsByIssueTypes
  **/
  @ApiModelProperty(value = "The list of required status mappings by issue type.")
  public List<RequiredMappingByIssueType> getStatusMappingsByIssueTypes() {
    return statusMappingsByIssueTypes;
  }

  public void setStatusMappingsByIssueTypes(List<RequiredMappingByIssueType> statusMappingsByIssueTypes) {
    this.statusMappingsByIssueTypes = statusMappingsByIssueTypes;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse statusMappingsByWorkflows(List<RequiredMappingByWorkflows> statusMappingsByWorkflows) {
    this.statusMappingsByWorkflows = statusMappingsByWorkflows;
    return this;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse addStatusMappingsByWorkflowsItem(RequiredMappingByWorkflows statusMappingsByWorkflowsItem) {
    if (this.statusMappingsByWorkflows == null) {
      this.statusMappingsByWorkflows = new ArrayList<>();
    }
    this.statusMappingsByWorkflows.add(statusMappingsByWorkflowsItem);
    return this;
  }

   /**
   * The list of required status mappings by workflow.
   * @return statusMappingsByWorkflows
  **/
  @ApiModelProperty(value = "The list of required status mappings by workflow.")
  public List<RequiredMappingByWorkflows> getStatusMappingsByWorkflows() {
    return statusMappingsByWorkflows;
  }

  public void setStatusMappingsByWorkflows(List<RequiredMappingByWorkflows> statusMappingsByWorkflows) {
    this.statusMappingsByWorkflows = statusMappingsByWorkflows;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse statuses(List<StatusMetadata> statuses) {
    this.statuses = statuses;
    return this;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse addStatusesItem(StatusMetadata statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The details of the statuses in the associated workflows.
   * @return statuses
  **/
  @ApiModelProperty(value = "The details of the statuses in the associated workflows.")
  public List<StatusMetadata> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<StatusMetadata> statuses) {
    this.statuses = statuses;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse statusesPerWorkflow(List<StatusesPerWorkflow> statusesPerWorkflow) {
    this.statusesPerWorkflow = statusesPerWorkflow;
    return this;
  }

  public WorkflowSchemeUpdateRequiredMappingsResponse addStatusesPerWorkflowItem(StatusesPerWorkflow statusesPerWorkflowItem) {
    if (this.statusesPerWorkflow == null) {
      this.statusesPerWorkflow = new ArrayList<>();
    }
    this.statusesPerWorkflow.add(statusesPerWorkflowItem);
    return this;
  }

   /**
   * The statuses associated with each workflow.
   * @return statusesPerWorkflow
  **/
  @ApiModelProperty(value = "The statuses associated with each workflow.")
  public List<StatusesPerWorkflow> getStatusesPerWorkflow() {
    return statusesPerWorkflow;
  }

  public void setStatusesPerWorkflow(List<StatusesPerWorkflow> statusesPerWorkflow) {
    this.statusesPerWorkflow = statusesPerWorkflow;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowSchemeUpdateRequiredMappingsResponse workflowSchemeUpdateRequiredMappingsResponse = (WorkflowSchemeUpdateRequiredMappingsResponse) o;
    return Objects.equals(this.statusMappingsByIssueTypes, workflowSchemeUpdateRequiredMappingsResponse.statusMappingsByIssueTypes) &&
        Objects.equals(this.statusMappingsByWorkflows, workflowSchemeUpdateRequiredMappingsResponse.statusMappingsByWorkflows) &&
        Objects.equals(this.statuses, workflowSchemeUpdateRequiredMappingsResponse.statuses) &&
        Objects.equals(this.statusesPerWorkflow, workflowSchemeUpdateRequiredMappingsResponse.statusesPerWorkflow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(statusMappingsByIssueTypes, statusMappingsByWorkflows, statuses, statusesPerWorkflow);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowSchemeUpdateRequiredMappingsResponse {\n");
    
    sb.append("    statusMappingsByIssueTypes: ").append(toIndentedString(statusMappingsByIssueTypes)).append("\n");
    sb.append("    statusMappingsByWorkflows: ").append(toIndentedString(statusMappingsByWorkflows)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    statusesPerWorkflow: ").append(toIndentedString(statusesPerWorkflow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

