/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowMetadataAndIssueTypeRestModel;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowMetadataRestModel;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowScope;

/**
 * WorkflowSchemeReadResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowSchemeReadResponse {
  @JsonProperty("defaultWorkflow")
  private WorkflowMetadataRestModel defaultWorkflow;

  @JsonProperty("description")
  private String description;

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectIdsUsingScheme")
  private List<String> projectIdsUsingScheme = new ArrayList<>();

  @JsonProperty("scope")
  private WorkflowScope scope;

  @JsonProperty("taskId")
  private String taskId;

  @JsonProperty("version")
  private DocumentVersion version;

  @JsonProperty("workflowsForIssueTypes")
  private List<WorkflowMetadataAndIssueTypeRestModel> workflowsForIssueTypes = new ArrayList<>();

  public WorkflowSchemeReadResponse defaultWorkflow(WorkflowMetadataRestModel defaultWorkflow) {
    this.defaultWorkflow = defaultWorkflow;
    return this;
  }

   /**
   * Get defaultWorkflow
   * @return defaultWorkflow
  **/
  @ApiModelProperty(value = "")
  public WorkflowMetadataRestModel getDefaultWorkflow() {
    return defaultWorkflow;
  }

  public void setDefaultWorkflow(WorkflowMetadataRestModel defaultWorkflow) {
    this.defaultWorkflow = defaultWorkflow;
  }

  public WorkflowSchemeReadResponse description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow scheme.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the workflow scheme.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WorkflowSchemeReadResponse id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the workflow scheme.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The ID of the workflow scheme.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WorkflowSchemeReadResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow scheme.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the workflow scheme.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WorkflowSchemeReadResponse projectIdsUsingScheme(List<String> projectIdsUsingScheme) {
    this.projectIdsUsingScheme = projectIdsUsingScheme;
    return this;
  }

  public WorkflowSchemeReadResponse addProjectIdsUsingSchemeItem(String projectIdsUsingSchemeItem) {
    this.projectIdsUsingScheme.add(projectIdsUsingSchemeItem);
    return this;
  }

   /**
   * The IDs of projects using the workflow scheme.
   * @return projectIdsUsingScheme
  **/
  @ApiModelProperty(required = true, value = "The IDs of projects using the workflow scheme.")
  public List<String> getProjectIdsUsingScheme() {
    return projectIdsUsingScheme;
  }

  public void setProjectIdsUsingScheme(List<String> projectIdsUsingScheme) {
    this.projectIdsUsingScheme = projectIdsUsingScheme;
  }

  public WorkflowSchemeReadResponse scope(WorkflowScope scope) {
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  @ApiModelProperty(required = true, value = "")
  public WorkflowScope getScope() {
    return scope;
  }

  public void setScope(WorkflowScope scope) {
    this.scope = scope;
  }

  public WorkflowSchemeReadResponse taskId(String taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * Indicates if there&#39;s an [asynchronous task](#async-operations) for this workflow scheme.
   * @return taskId
  **/
  @ApiModelProperty(value = "Indicates if there's an [asynchronous task](#async-operations) for this workflow scheme.")
  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public WorkflowSchemeReadResponse version(DocumentVersion version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(required = true, value = "")
  public DocumentVersion getVersion() {
    return version;
  }

  public void setVersion(DocumentVersion version) {
    this.version = version;
  }

  public WorkflowSchemeReadResponse workflowsForIssueTypes(List<WorkflowMetadataAndIssueTypeRestModel> workflowsForIssueTypes) {
    this.workflowsForIssueTypes = workflowsForIssueTypes;
    return this;
  }

  public WorkflowSchemeReadResponse addWorkflowsForIssueTypesItem(WorkflowMetadataAndIssueTypeRestModel workflowsForIssueTypesItem) {
    this.workflowsForIssueTypes.add(workflowsForIssueTypesItem);
    return this;
  }

   /**
   * Mappings from workflows to issue types.
   * @return workflowsForIssueTypes
  **/
  @ApiModelProperty(required = true, value = "Mappings from workflows to issue types.")
  public List<WorkflowMetadataAndIssueTypeRestModel> getWorkflowsForIssueTypes() {
    return workflowsForIssueTypes;
  }

  public void setWorkflowsForIssueTypes(List<WorkflowMetadataAndIssueTypeRestModel> workflowsForIssueTypes) {
    this.workflowsForIssueTypes = workflowsForIssueTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowSchemeReadResponse workflowSchemeReadResponse = (WorkflowSchemeReadResponse) o;
    return Objects.equals(this.defaultWorkflow, workflowSchemeReadResponse.defaultWorkflow) &&
        Objects.equals(this.description, workflowSchemeReadResponse.description) &&
        Objects.equals(this.id, workflowSchemeReadResponse.id) &&
        Objects.equals(this.name, workflowSchemeReadResponse.name) &&
        Objects.equals(this.projectIdsUsingScheme, workflowSchemeReadResponse.projectIdsUsingScheme) &&
        Objects.equals(this.scope, workflowSchemeReadResponse.scope) &&
        Objects.equals(this.taskId, workflowSchemeReadResponse.taskId) &&
        Objects.equals(this.version, workflowSchemeReadResponse.version) &&
        Objects.equals(this.workflowsForIssueTypes, workflowSchemeReadResponse.workflowsForIssueTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultWorkflow, description, id, name, projectIdsUsingScheme, scope, taskId, version, workflowsForIssueTypes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowSchemeReadResponse {\n");
    
    sb.append("    defaultWorkflow: ").append(toIndentedString(defaultWorkflow)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectIdsUsingScheme: ").append(toIndentedString(projectIdsUsingScheme)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    workflowsForIssueTypes: ").append(toIndentedString(workflowsForIssueTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

