/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Details of the workflow and its transition rules.
 */
@ApiModel(description = "Details of the workflow and its transition rules.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowRulesSearch {
  @JsonProperty("expand")
  private String expand;

  @JsonProperty("ruleIds")
  private List<UUID> ruleIds = new ArrayList<>();

  @JsonProperty("workflowEntityId")
  private UUID workflowEntityId;

  public WorkflowRulesSearch expand(String expand) {
    this.expand = expand;
    return this;
  }

   /**
   * Use expand to include additional information in the response. This parameter accepts &#x60;transition&#x60; which, for each rule, returns information about the transition the rule is assigned to.
   * @return expand
  **/
  @ApiModelProperty(example = "transition", value = "Use expand to include additional information in the response. This parameter accepts `transition` which, for each rule, returns information about the transition the rule is assigned to.")
  public String getExpand() {
    return expand;
  }

  public void setExpand(String expand) {
    this.expand = expand;
  }

  public WorkflowRulesSearch ruleIds(List<UUID> ruleIds) {
    this.ruleIds = ruleIds;
    return this;
  }

  public WorkflowRulesSearch addRuleIdsItem(UUID ruleIdsItem) {
    this.ruleIds.add(ruleIdsItem);
    return this;
  }

   /**
   * The list of workflow rule IDs.
   * @return ruleIds
  **/
  @ApiModelProperty(required = true, value = "The list of workflow rule IDs.")
  public List<UUID> getRuleIds() {
    return ruleIds;
  }

  public void setRuleIds(List<UUID> ruleIds) {
    this.ruleIds = ruleIds;
  }

  public WorkflowRulesSearch workflowEntityId(UUID workflowEntityId) {
    this.workflowEntityId = workflowEntityId;
    return this;
  }

   /**
   * The workflow ID.
   * @return workflowEntityId
  **/
  @ApiModelProperty(example = "a498d711-685d-428d-8c3e-bc03bb450ea7", required = true, value = "The workflow ID.")
  public UUID getWorkflowEntityId() {
    return workflowEntityId;
  }

  public void setWorkflowEntityId(UUID workflowEntityId) {
    this.workflowEntityId = workflowEntityId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowRulesSearch workflowRulesSearch = (WorkflowRulesSearch) o;
    return Objects.equals(this.expand, workflowRulesSearch.expand) &&
        Objects.equals(this.ruleIds, workflowRulesSearch.ruleIds) &&
        Objects.equals(this.workflowEntityId, workflowRulesSearch.workflowEntityId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, ruleIds, workflowEntityId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowRulesSearch {\n");
    
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    ruleIds: ").append(toIndentedString(ruleIds)).append("\n");
    sb.append("    workflowEntityId: ").append(toIndentedString(workflowEntityId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

