/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowStatusLayout;

/**
 * The statuses referenced in the workflow.
 */
@ApiModel(description = "The statuses referenced in the workflow.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowReferenceStatus {
  @JsonProperty("deprecated")
  private Boolean deprecated;

  @JsonProperty("layout")
  private WorkflowStatusLayout layout;

  @JsonProperty("properties")
  private Map<String, String> properties = new HashMap<>();

  @JsonProperty("statusReference")
  private String statusReference;

  public WorkflowReferenceStatus deprecated(Boolean deprecated) {
    this.deprecated = deprecated;
    return this;
  }

   /**
   * Indicates if the status is deprecated.
   * @return deprecated
  **/
  @ApiModelProperty(value = "Indicates if the status is deprecated.")
  public Boolean getDeprecated() {
    return deprecated;
  }

  public void setDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
  }

  public WorkflowReferenceStatus layout(WorkflowStatusLayout layout) {
    this.layout = layout;
    return this;
  }

   /**
   * Get layout
   * @return layout
  **/
  @ApiModelProperty(value = "")
  public WorkflowStatusLayout getLayout() {
    return layout;
  }

  public void setLayout(WorkflowStatusLayout layout) {
    this.layout = layout;
  }

  public WorkflowReferenceStatus properties(Map<String, String> properties) {
    this.properties = properties;
    return this;
  }

  public WorkflowReferenceStatus putPropertiesItem(String key, String propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * The properties associated with the status.
   * @return properties
  **/
  @ApiModelProperty(value = "The properties associated with the status.")
  public Map<String, String> getProperties() {
    return properties;
  }

  public void setProperties(Map<String, String> properties) {
    this.properties = properties;
  }

  public WorkflowReferenceStatus statusReference(String statusReference) {
    this.statusReference = statusReference;
    return this;
  }

   /**
   * The reference of the status.
   * @return statusReference
  **/
  @ApiModelProperty(value = "The reference of the status.")
  public String getStatusReference() {
    return statusReference;
  }

  public void setStatusReference(String statusReference) {
    this.statusReference = statusReference;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowReferenceStatus workflowReferenceStatus = (WorkflowReferenceStatus) o;
    return Objects.equals(this.deprecated, workflowReferenceStatus.deprecated) &&
        Objects.equals(this.layout, workflowReferenceStatus.layout) &&
        Objects.equals(this.properties, workflowReferenceStatus.properties) &&
        Objects.equals(this.statusReference, workflowReferenceStatus.statusReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deprecated, layout, properties, statusReference);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowReferenceStatus {\n");
    
    sb.append("    deprecated: ").append(toIndentedString(deprecated)).append("\n");
    sb.append("    layout: ").append(toIndentedString(layout)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    statusReference: ").append(toIndentedString(statusReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

