/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectAndIssueTypePair;

/**
 * A reference to the location of the error. This will be null if the error does not refer to a specific element.
 */
@ApiModel(description = "A reference to the location of the error. This will be null if the error does not refer to a specific element.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowElementReference {
  @JsonProperty("propertyKey")
  private String propertyKey;

  @JsonProperty("ruleId")
  private String ruleId;

  @JsonProperty("statusMappingReference")
  private ProjectAndIssueTypePair statusMappingReference;

  @JsonProperty("statusReference")
  private String statusReference;

  @JsonProperty("transitionId")
  private String transitionId;

  public WorkflowElementReference propertyKey(String propertyKey) {
    this.propertyKey = propertyKey;
    return this;
  }

   /**
   * A property key.
   * @return propertyKey
  **/
  @ApiModelProperty(value = "A property key.")
  public String getPropertyKey() {
    return propertyKey;
  }

  public void setPropertyKey(String propertyKey) {
    this.propertyKey = propertyKey;
  }

  public WorkflowElementReference ruleId(String ruleId) {
    this.ruleId = ruleId;
    return this;
  }

   /**
   * A rule ID.
   * @return ruleId
  **/
  @ApiModelProperty(value = "A rule ID.")
  public String getRuleId() {
    return ruleId;
  }

  public void setRuleId(String ruleId) {
    this.ruleId = ruleId;
  }

  public WorkflowElementReference statusMappingReference(ProjectAndIssueTypePair statusMappingReference) {
    this.statusMappingReference = statusMappingReference;
    return this;
  }

   /**
   * Get statusMappingReference
   * @return statusMappingReference
  **/
  @ApiModelProperty(value = "")
  public ProjectAndIssueTypePair getStatusMappingReference() {
    return statusMappingReference;
  }

  public void setStatusMappingReference(ProjectAndIssueTypePair statusMappingReference) {
    this.statusMappingReference = statusMappingReference;
  }

  public WorkflowElementReference statusReference(String statusReference) {
    this.statusReference = statusReference;
    return this;
  }

   /**
   * A status reference.
   * @return statusReference
  **/
  @ApiModelProperty(value = "A status reference.")
  public String getStatusReference() {
    return statusReference;
  }

  public void setStatusReference(String statusReference) {
    this.statusReference = statusReference;
  }

  public WorkflowElementReference transitionId(String transitionId) {
    this.transitionId = transitionId;
    return this;
  }

   /**
   * A transition ID.
   * @return transitionId
  **/
  @ApiModelProperty(value = "A transition ID.")
  public String getTransitionId() {
    return transitionId;
  }

  public void setTransitionId(String transitionId) {
    this.transitionId = transitionId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowElementReference workflowElementReference = (WorkflowElementReference) o;
    return Objects.equals(this.propertyKey, workflowElementReference.propertyKey) &&
        Objects.equals(this.ruleId, workflowElementReference.ruleId) &&
        Objects.equals(this.statusMappingReference, workflowElementReference.statusMappingReference) &&
        Objects.equals(this.statusReference, workflowElementReference.statusReference) &&
        Objects.equals(this.transitionId, workflowElementReference.transitionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(propertyKey, ruleId, statusMappingReference, statusReference, transitionId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowElementReference {\n");
    
    sb.append("    propertyKey: ").append(toIndentedString(propertyKey)).append("\n");
    sb.append("    ruleId: ").append(toIndentedString(ruleId)).append("\n");
    sb.append("    statusMappingReference: ").append(toIndentedString(statusMappingReference)).append("\n");
    sb.append("    statusReference: ").append(toIndentedString(statusReference)).append("\n");
    sb.append("    transitionId: ").append(toIndentedString(transitionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

