/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.JiraWorkflow;
import org.everit.atlassian.restclient.jiracloud.v3.model.JiraWorkflowStatus;

/**
 * Details of the created workflows and statuses.
 */
@ApiModel(description = "Details of the created workflows and statuses.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowCreateResponse {
  @JsonProperty("statuses")
  private List<JiraWorkflowStatus> statuses = new ArrayList<>();

  @JsonProperty("workflows")
  private List<JiraWorkflow> workflows = new ArrayList<>();

  public WorkflowCreateResponse statuses(List<JiraWorkflowStatus> statuses) {
    this.statuses = statuses;
    return this;
  }

  public WorkflowCreateResponse addStatusesItem(JiraWorkflowStatus statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * List of created statuses.
   * @return statuses
  **/
  @ApiModelProperty(value = "List of created statuses.")
  public List<JiraWorkflowStatus> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<JiraWorkflowStatus> statuses) {
    this.statuses = statuses;
  }

  public WorkflowCreateResponse workflows(List<JiraWorkflow> workflows) {
    this.workflows = workflows;
    return this;
  }

  public WorkflowCreateResponse addWorkflowsItem(JiraWorkflow workflowsItem) {
    if (this.workflows == null) {
      this.workflows = new ArrayList<>();
    }
    this.workflows.add(workflowsItem);
    return this;
  }

   /**
   * List of created workflows.
   * @return workflows
  **/
  @ApiModelProperty(value = "List of created workflows.")
  public List<JiraWorkflow> getWorkflows() {
    return workflows;
  }

  public void setWorkflows(List<JiraWorkflow> workflows) {
    this.workflows = workflows;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowCreateResponse workflowCreateResponse = (WorkflowCreateResponse) o;
    return Objects.equals(this.statuses, workflowCreateResponse.statuses) &&
        Objects.equals(this.workflows, workflowCreateResponse.workflows);
  }

  @Override
  public int hashCode() {
    return Objects.hash(statuses, workflows);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowCreateResponse {\n");
    
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    workflows: ").append(toIndentedString(workflows)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

