/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.StatusLayoutUpdate;
import org.everit.atlassian.restclient.jiracloud.v3.model.TransitionUpdateDTO;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowLayout;

/**
 * The details of the workflows to create.
 */
@ApiModel(description = "The details of the workflows to create.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class WorkflowCreate {
  @JsonProperty("description")
  private String description;

  @JsonProperty("name")
  private String name;

  @JsonProperty("startPointLayout")
  private WorkflowLayout startPointLayout;

  @JsonProperty("statuses")
  private List<StatusLayoutUpdate> statuses = new ArrayList<>();

  @JsonProperty("transitions")
  private List<TransitionUpdateDTO> transitions = new ArrayList<>();

  public WorkflowCreate description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow to create.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the workflow to create.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WorkflowCreate name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow to create.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the workflow to create.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WorkflowCreate startPointLayout(WorkflowLayout startPointLayout) {
    this.startPointLayout = startPointLayout;
    return this;
  }

   /**
   * Get startPointLayout
   * @return startPointLayout
  **/
  @ApiModelProperty(value = "")
  public WorkflowLayout getStartPointLayout() {
    return startPointLayout;
  }

  public void setStartPointLayout(WorkflowLayout startPointLayout) {
    this.startPointLayout = startPointLayout;
  }

  public WorkflowCreate statuses(List<StatusLayoutUpdate> statuses) {
    this.statuses = statuses;
    return this;
  }

  public WorkflowCreate addStatusesItem(StatusLayoutUpdate statusesItem) {
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The statuses associated with this workflow.
   * @return statuses
  **/
  @ApiModelProperty(required = true, value = "The statuses associated with this workflow.")
  public List<StatusLayoutUpdate> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<StatusLayoutUpdate> statuses) {
    this.statuses = statuses;
  }

  public WorkflowCreate transitions(List<TransitionUpdateDTO> transitions) {
    this.transitions = transitions;
    return this;
  }

  public WorkflowCreate addTransitionsItem(TransitionUpdateDTO transitionsItem) {
    this.transitions.add(transitionsItem);
    return this;
  }

   /**
   * The transitions of this workflow.
   * @return transitions
  **/
  @ApiModelProperty(required = true, value = "The transitions of this workflow.")
  public List<TransitionUpdateDTO> getTransitions() {
    return transitions;
  }

  public void setTransitions(List<TransitionUpdateDTO> transitions) {
    this.transitions = transitions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowCreate workflowCreate = (WorkflowCreate) o;
    return Objects.equals(this.description, workflowCreate.description) &&
        Objects.equals(this.name, workflowCreate.name) &&
        Objects.equals(this.startPointLayout, workflowCreate.startPointLayout) &&
        Objects.equals(this.statuses, workflowCreate.statuses) &&
        Objects.equals(this.transitions, workflowCreate.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, name, startPointLayout, statuses, transitions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowCreate {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    startPointLayout: ").append(toIndentedString(startPointLayout)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

