/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;

/**
 * The details of watchers on an issue.
 */
@ApiModel(description = "The details of watchers on an issue.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class Watchers {
  @JsonProperty("isWatching")
  private Boolean isWatching;

  @JsonProperty("self")
  private String self;

  @JsonProperty("watchCount")
  private Integer watchCount;

  @JsonProperty("watchers")
  private List<UserDetails> watchers = new ArrayList<>();

   /**
   * Whether the calling user is watching this issue.
   * @return isWatching
  **/
  @ApiModelProperty(value = "Whether the calling user is watching this issue.")
  public Boolean getIsWatching() {
    return isWatching;
  }

   /**
   * The URL of these issue watcher details.
   * @return self
  **/
  @ApiModelProperty(value = "The URL of these issue watcher details.")
  public String getSelf() {
    return self;
  }

   /**
   * The number of users watching this issue.
   * @return watchCount
  **/
  @ApiModelProperty(value = "The number of users watching this issue.")
  public Integer getWatchCount() {
    return watchCount;
  }

   /**
   * Details of the users watching this issue.
   * @return watchers
  **/
  @ApiModelProperty(value = "Details of the users watching this issue.")
  public List<UserDetails> getWatchers() {
    return watchers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Watchers watchers = (Watchers) o;
    return Objects.equals(this.isWatching, watchers.isWatching) &&
        Objects.equals(this.self, watchers.self) &&
        Objects.equals(this.watchCount, watchers.watchCount) &&
        Objects.equals(this.watchers, watchers.watchers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isWatching, self, watchCount, watchers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Watchers {\n");
    
    sb.append("    isWatching: ").append(toIndentedString(isWatching)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    watchCount: ").append(toIndentedString(watchCount)).append("\n");
    sb.append("    watchers: ").append(toIndentedString(watchers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

