/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * Details of an issue priority.
 */
@ApiModel(description = "Details of an issue priority.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class UpdatePriorityDetails {
  @JsonProperty("description")
  private String description;

  /**
   * The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used.
   */
  public enum IconUrlEnum {
    BLOCKER_PNG("/images/icons/priorities/blocker.png"),
    
    CRITICAL_PNG("/images/icons/priorities/critical.png"),
    
    HIGH_PNG("/images/icons/priorities/high.png"),
    
    HIGHEST_PNG("/images/icons/priorities/highest.png"),
    
    LOW_PNG("/images/icons/priorities/low.png"),
    
    LOWEST_PNG("/images/icons/priorities/lowest.png"),
    
    MAJOR_PNG("/images/icons/priorities/major.png"),
    
    MEDIUM_PNG("/images/icons/priorities/medium.png"),
    
    MINOR_PNG("/images/icons/priorities/minor.png"),
    
    TRIVIAL_PNG("/images/icons/priorities/trivial.png");

    private String value;

    IconUrlEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IconUrlEnum fromValue(String value) {
      for (IconUrlEnum b : IconUrlEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("iconUrl")
  private IconUrlEnum iconUrl;

  @JsonProperty("name")
  private String name;

  @JsonProperty("statusColor")
  private String statusColor;

  private HashMap<String, Object> additionalProperties_ = new HashMap<String, Object>();

  public UpdatePriorityDetails description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the priority.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the priority.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public UpdatePriorityDetails iconUrl(IconUrlEnum iconUrl) {
    this.iconUrl = iconUrl;
    return this;
  }

   /**
   * The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used.
   * @return iconUrl
  **/
  @ApiModelProperty(value = "The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used.")
  public IconUrlEnum getIconUrl() {
    return iconUrl;
  }

  public void setIconUrl(IconUrlEnum iconUrl) {
    this.iconUrl = iconUrl;
  }

  public UpdatePriorityDetails name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the priority. Must be unique.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the priority. Must be unique.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public UpdatePriorityDetails statusColor(String statusColor) {
    this.statusColor = statusColor;
    return this;
  }

   /**
   * The status color of the priority in 3-digit or 6-digit hexadecimal format.
   * @return statusColor
  **/
  @ApiModelProperty(value = "The status color of the priority in 3-digit or 6-digit hexadecimal format.")
  public String getStatusColor() {
    return statusColor;
  }

  public void setStatusColor(String statusColor) {
    this.statusColor = statusColor;
  }


  @com.fasterxml.jackson.annotation.JsonAnyGetter
  public Map<String, Object> any() {
   return this.additionalProperties_;
  }

  @com.fasterxml.jackson.annotation.JsonAnySetter
  public void set(String name, Object value) {
   this.additionalProperties_.put(name, value);
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdatePriorityDetails updatePriorityDetails = (UpdatePriorityDetails) o;
    return Objects.equals(this.description, updatePriorityDetails.description) &&
        Objects.equals(this.iconUrl, updatePriorityDetails.iconUrl) &&
        Objects.equals(this.name, updatePriorityDetails.name) &&
        Objects.equals(this.statusColor, updatePriorityDetails.statusColor) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, iconUrl, name, statusColor, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdatePriorityDetails {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    iconUrl: ").append(toIndentedString(iconUrl)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    statusColor: ").append(toIndentedString(statusColor)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties_)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

