/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * The details of a UI modification&#39;s context, which define where to activate the UI modification.
 */
@ApiModel(description = "The details of a UI modification's context, which define where to activate the UI modification.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class UiModificationContextDetails {
  @JsonProperty("id")
  private String id;

  @JsonProperty("isAvailable")
  private Boolean isAvailable;

  @JsonProperty("issueTypeId")
  private String issueTypeId;

  @JsonProperty("projectId")
  private String projectId;

  /**
   * The view type of the context. Only &#x60;GIC&#x60;(Global Issue Create) and &#x60;IssueView&#x60; are supported.
   */
  public enum ViewTypeEnum {
    GIC("GIC"),
    
    ISSUEVIEW("IssueView");

    private String value;

    ViewTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ViewTypeEnum fromValue(String value) {
      for (ViewTypeEnum b : ViewTypeEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("viewType")
  private ViewTypeEnum viewType;

   /**
   * The ID of the UI modification context.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the UI modification context.")
  public String getId() {
    return id;
  }

   /**
   * Whether a context is available. For example, when a project is deleted the context becomes unavailable.
   * @return isAvailable
  **/
  @ApiModelProperty(value = "Whether a context is available. For example, when a project is deleted the context becomes unavailable.")
  public Boolean getIsAvailable() {
    return isAvailable;
  }

  public UiModificationContextDetails issueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
    return this;
  }

   /**
   * The issue type ID of the context.
   * @return issueTypeId
  **/
  @ApiModelProperty(required = true, value = "The issue type ID of the context.")
  public String getIssueTypeId() {
    return issueTypeId;
  }

  public void setIssueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
  }

  public UiModificationContextDetails projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * The project ID of the context.
   * @return projectId
  **/
  @ApiModelProperty(required = true, value = "The project ID of the context.")
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public UiModificationContextDetails viewType(ViewTypeEnum viewType) {
    this.viewType = viewType;
    return this;
  }

   /**
   * The view type of the context. Only &#x60;GIC&#x60;(Global Issue Create) and &#x60;IssueView&#x60; are supported.
   * @return viewType
  **/
  @ApiModelProperty(required = true, value = "The view type of the context. Only `GIC`(Global Issue Create) and `IssueView` are supported.")
  public ViewTypeEnum getViewType() {
    return viewType;
  }

  public void setViewType(ViewTypeEnum viewType) {
    this.viewType = viewType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiModificationContextDetails uiModificationContextDetails = (UiModificationContextDetails) o;
    return Objects.equals(this.id, uiModificationContextDetails.id) &&
        Objects.equals(this.isAvailable, uiModificationContextDetails.isAvailable) &&
        Objects.equals(this.issueTypeId, uiModificationContextDetails.issueTypeId) &&
        Objects.equals(this.projectId, uiModificationContextDetails.projectId) &&
        Objects.equals(this.viewType, uiModificationContextDetails.viewType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, isAvailable, issueTypeId, projectId, viewType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiModificationContextDetails {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    isAvailable: ").append(toIndentedString(isAvailable)).append("\n");
    sb.append("    issueTypeId: ").append(toIndentedString(issueTypeId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    viewType: ").append(toIndentedString(viewType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

