/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * The statuses associated with each workflow.
 */
@ApiModel(description = "The statuses associated with each workflow.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class StatusesPerWorkflow {
  @JsonProperty("initialStatusId")
  private String initialStatusId;

  @JsonProperty("statuses")
  private List<String> statuses = new ArrayList<>();

  @JsonProperty("workflowId")
  private String workflowId;

  public StatusesPerWorkflow initialStatusId(String initialStatusId) {
    this.initialStatusId = initialStatusId;
    return this;
  }

   /**
   * The ID of the initial status for the workflow.
   * @return initialStatusId
  **/
  @ApiModelProperty(value = "The ID of the initial status for the workflow.")
  public String getInitialStatusId() {
    return initialStatusId;
  }

  public void setInitialStatusId(String initialStatusId) {
    this.initialStatusId = initialStatusId;
  }

  public StatusesPerWorkflow statuses(List<String> statuses) {
    this.statuses = statuses;
    return this;
  }

  public StatusesPerWorkflow addStatusesItem(String statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The status IDs associated with the workflow.
   * @return statuses
  **/
  @ApiModelProperty(value = "The status IDs associated with the workflow.")
  public List<String> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<String> statuses) {
    this.statuses = statuses;
  }

  public StatusesPerWorkflow workflowId(String workflowId) {
    this.workflowId = workflowId;
    return this;
  }

   /**
   * The ID of the workflow.
   * @return workflowId
  **/
  @ApiModelProperty(value = "The ID of the workflow.")
  public String getWorkflowId() {
    return workflowId;
  }

  public void setWorkflowId(String workflowId) {
    this.workflowId = workflowId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatusesPerWorkflow statusesPerWorkflow = (StatusesPerWorkflow) o;
    return Objects.equals(this.initialStatusId, statusesPerWorkflow.initialStatusId) &&
        Objects.equals(this.statuses, statusesPerWorkflow.statuses) &&
        Objects.equals(this.workflowId, statusesPerWorkflow.workflowId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(initialStatusId, statuses, workflowId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatusesPerWorkflow {\n");
    
    sb.append("    initialStatusId: ").append(toIndentedString(initialStatusId)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    workflowId: ").append(toIndentedString(workflowId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

