/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * Jql function precomputation.
 */
@ApiModel(description = "Jql function precomputation.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class JqlFunctionPrecomputationBean {
  @JsonProperty("arguments")
  private List<String> arguments = new ArrayList<>();

  @JsonProperty("created")
  private OffsetDateTime created;

  @JsonProperty("error")
  private String error;

  @JsonProperty("field")
  private String field;

  @JsonProperty("functionKey")
  private String functionKey;

  @JsonProperty("functionName")
  private String functionName;

  @JsonProperty("id")
  private String id;

  @JsonProperty("operator")
  private String operator;

  @JsonProperty("updated")
  private OffsetDateTime updated;

  @JsonProperty("used")
  private OffsetDateTime used;

  @JsonProperty("value")
  private String value;

   /**
   * The list of arguments function was invoked with.
   * @return arguments
  **/
  @ApiModelProperty(value = "The list of arguments function was invoked with.")
  public List<String> getArguments() {
    return arguments;
  }

   /**
   * The timestamp of the precomputation creation.
   * @return created
  **/
  @ApiModelProperty(value = "The timestamp of the precomputation creation.")
  public OffsetDateTime getCreated() {
    return created;
  }

   /**
   * The error message to be displayed to the user.
   * @return error
  **/
  @ApiModelProperty(value = "The error message to be displayed to the user.")
  public String getError() {
    return error;
  }

   /**
   * The field the function was executed against.
   * @return field
  **/
  @ApiModelProperty(value = "The field the function was executed against.")
  public String getField() {
    return field;
  }

   /**
   * The function key.
   * @return functionKey
  **/
  @ApiModelProperty(value = "The function key.")
  public String getFunctionKey() {
    return functionKey;
  }

   /**
   * The name of the function.
   * @return functionName
  **/
  @ApiModelProperty(value = "The name of the function.")
  public String getFunctionName() {
    return functionName;
  }

   /**
   * The id of the precomputation.
   * @return id
  **/
  @ApiModelProperty(value = "The id of the precomputation.")
  public String getId() {
    return id;
  }

   /**
   * The operator in context of which function was executed.
   * @return operator
  **/
  @ApiModelProperty(value = "The operator in context of which function was executed.")
  public String getOperator() {
    return operator;
  }

   /**
   * The timestamp of the precomputation last update.
   * @return updated
  **/
  @ApiModelProperty(value = "The timestamp of the precomputation last update.")
  public OffsetDateTime getUpdated() {
    return updated;
  }

   /**
   * The timestamp of the precomputation last usage.
   * @return used
  **/
  @ApiModelProperty(value = "The timestamp of the precomputation last usage.")
  public OffsetDateTime getUsed() {
    return used;
  }

   /**
   * The JQL fragment stored as the precomputation.
   * @return value
  **/
  @ApiModelProperty(value = "The JQL fragment stored as the precomputation.")
  public String getValue() {
    return value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JqlFunctionPrecomputationBean jqlFunctionPrecomputationBean = (JqlFunctionPrecomputationBean) o;
    return Objects.equals(this.arguments, jqlFunctionPrecomputationBean.arguments) &&
        Objects.equals(this.created, jqlFunctionPrecomputationBean.created) &&
        Objects.equals(this.error, jqlFunctionPrecomputationBean.error) &&
        Objects.equals(this.field, jqlFunctionPrecomputationBean.field) &&
        Objects.equals(this.functionKey, jqlFunctionPrecomputationBean.functionKey) &&
        Objects.equals(this.functionName, jqlFunctionPrecomputationBean.functionName) &&
        Objects.equals(this.id, jqlFunctionPrecomputationBean.id) &&
        Objects.equals(this.operator, jqlFunctionPrecomputationBean.operator) &&
        Objects.equals(this.updated, jqlFunctionPrecomputationBean.updated) &&
        Objects.equals(this.used, jqlFunctionPrecomputationBean.used) &&
        Objects.equals(this.value, jqlFunctionPrecomputationBean.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arguments, created, error, field, functionKey, functionName, id, operator, updated, used, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JqlFunctionPrecomputationBean {\n");
    
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    functionKey: ").append(toIndentedString(functionKey)).append("\n");
    sb.append("    functionName: ").append(toIndentedString(functionName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("    used: ").append(toIndentedString(used)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

