/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * Details of functions that can be used in advanced searches.
 */
@ApiModel(description = "Details of functions that can be used in advanced searches.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class FunctionReferenceData {
  @JsonProperty("displayName")
  private String displayName;

  /**
   * Whether the function can take a list of arguments.
   */
  public enum IsListEnum {
    TRUE("true"),
    
    FALSE("false");

    private String value;

    IsListEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IsListEnum fromValue(String value) {
      for (IsListEnum b : IsListEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("isList")
  private IsListEnum isList;

  /**
   * Whether the function supports both single and list value operators.
   */
  public enum SupportsListAndSingleValueOperatorsEnum {
    TRUE("true"),
    
    FALSE("false");

    private String value;

    SupportsListAndSingleValueOperatorsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SupportsListAndSingleValueOperatorsEnum fromValue(String value) {
      for (SupportsListAndSingleValueOperatorsEnum b : SupportsListAndSingleValueOperatorsEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("supportsListAndSingleValueOperators")
  private SupportsListAndSingleValueOperatorsEnum supportsListAndSingleValueOperators;

  @JsonProperty("types")
  private List<String> types = new ArrayList<>();

  @JsonProperty("value")
  private String value;

  public FunctionReferenceData displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * The display name of the function.
   * @return displayName
  **/
  @ApiModelProperty(value = "The display name of the function.")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public FunctionReferenceData isList(IsListEnum isList) {
    this.isList = isList;
    return this;
  }

   /**
   * Whether the function can take a list of arguments.
   * @return isList
  **/
  @ApiModelProperty(value = "Whether the function can take a list of arguments.")
  public IsListEnum getIsList() {
    return isList;
  }

  public void setIsList(IsListEnum isList) {
    this.isList = isList;
  }

  public FunctionReferenceData supportsListAndSingleValueOperators(SupportsListAndSingleValueOperatorsEnum supportsListAndSingleValueOperators) {
    this.supportsListAndSingleValueOperators = supportsListAndSingleValueOperators;
    return this;
  }

   /**
   * Whether the function supports both single and list value operators.
   * @return supportsListAndSingleValueOperators
  **/
  @ApiModelProperty(value = "Whether the function supports both single and list value operators.")
  public SupportsListAndSingleValueOperatorsEnum getSupportsListAndSingleValueOperators() {
    return supportsListAndSingleValueOperators;
  }

  public void setSupportsListAndSingleValueOperators(SupportsListAndSingleValueOperatorsEnum supportsListAndSingleValueOperators) {
    this.supportsListAndSingleValueOperators = supportsListAndSingleValueOperators;
  }

  public FunctionReferenceData types(List<String> types) {
    this.types = types;
    return this;
  }

  public FunctionReferenceData addTypesItem(String typesItem) {
    if (this.types == null) {
      this.types = new ArrayList<>();
    }
    this.types.add(typesItem);
    return this;
  }

   /**
   * The data types returned by the function.
   * @return types
  **/
  @ApiModelProperty(value = "The data types returned by the function.")
  public List<String> getTypes() {
    return types;
  }

  public void setTypes(List<String> types) {
    this.types = types;
  }

  public FunctionReferenceData value(String value) {
    this.value = value;
    return this;
  }

   /**
   * The function identifier.
   * @return value
  **/
  @ApiModelProperty(value = "The function identifier.")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FunctionReferenceData functionReferenceData = (FunctionReferenceData) o;
    return Objects.equals(this.displayName, functionReferenceData.displayName) &&
        Objects.equals(this.isList, functionReferenceData.isList) &&
        Objects.equals(this.supportsListAndSingleValueOperators, functionReferenceData.supportsListAndSingleValueOperators) &&
        Objects.equals(this.types, functionReferenceData.types) &&
        Objects.equals(this.value, functionReferenceData.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayName, isList, supportsListAndSingleValueOperators, types, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FunctionReferenceData {\n");
    
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    isList: ").append(toIndentedString(isList)).append("\n");
    sb.append("    supportsListAndSingleValueOperators: ").append(toIndentedString(supportsListAndSingleValueOperators)).append("\n");
    sb.append("    types: ").append(toIndentedString(types)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

