/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Details of an operation to perform on a field.
 */
@ApiModel(description = "Details of an operation to perform on a field.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
public
                    class FieldUpdateOperation {
  @JsonProperty("add")
  private Object add = null;

  @JsonProperty("copy")
  private Object copy = null;

  @JsonProperty("edit")
  private Object edit = null;

  @JsonProperty("remove")
  private Object remove = null;

  @JsonProperty("set")
  private Object set = null;

  public FieldUpdateOperation add(Object add) {
    this.add = add;
    return this;
  }

   /**
   * The value to add to the field.
   * @return add
  **/
  @ApiModelProperty(example = "triaged", value = "The value to add to the field.")
  public Object getAdd() {
    return add;
  }

  public void setAdd(Object add) {
    this.add = add;
  }

  public FieldUpdateOperation copy(Object copy) {
    this.copy = copy;
    return this;
  }

   /**
   * The field value to copy from another issue.
   * @return copy
  **/
  @ApiModelProperty(example = "{\"issuelinks\":{\"sourceIssues\":[{\"key\":\"FP-5\"}]}}", value = "The field value to copy from another issue.")
  public Object getCopy() {
    return copy;
  }

  public void setCopy(Object copy) {
    this.copy = copy;
  }

  public FieldUpdateOperation edit(Object edit) {
    this.edit = edit;
    return this;
  }

   /**
   * The value to edit in the field.
   * @return edit
  **/
  @ApiModelProperty(example = "{\"originalEstimate\":\"1w 1d\",\"remainingEstimate\":\"4d\"}", value = "The value to edit in the field.")
  public Object getEdit() {
    return edit;
  }

  public void setEdit(Object edit) {
    this.edit = edit;
  }

  public FieldUpdateOperation remove(Object remove) {
    this.remove = remove;
    return this;
  }

   /**
   * The value to removed from the field.
   * @return remove
  **/
  @ApiModelProperty(example = "blocker", value = "The value to removed from the field.")
  public Object getRemove() {
    return remove;
  }

  public void setRemove(Object remove) {
    this.remove = remove;
  }

  public FieldUpdateOperation set(Object set) {
    this.set = set;
    return this;
  }

   /**
   * The value to set in the field.
   * @return set
  **/
  @ApiModelProperty(example = "A new summary", value = "The value to set in the field.")
  public Object getSet() {
    return set;
  }

  public void setSet(Object set) {
    this.set = set;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldUpdateOperation fieldUpdateOperation = (FieldUpdateOperation) o;
    return Objects.equals(this.add, fieldUpdateOperation.add) &&
        Objects.equals(this.copy, fieldUpdateOperation.copy) &&
        Objects.equals(this.edit, fieldUpdateOperation.edit) &&
        Objects.equals(this.remove, fieldUpdateOperation.remove) &&
        Objects.equals(this.set, fieldUpdateOperation.set);
  }

  @Override
  public int hashCode() {
    return Objects.hash(add, copy, edit, remove, set);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldUpdateOperation {\n");
    
    sb.append("    add: ").append(toIndentedString(add)).append("\n");
    sb.append("    copy: ").append(toIndentedString(copy)).append("\n");
    sb.append("    edit: ").append(toIndentedString(edit)).append("\n");
    sb.append("    remove: ").append(toIndentedString(remove)).append("\n");
    sb.append("    set: ").append(toIndentedString(set)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

