/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * The default value for a multiple version picker custom field.
 */
@ApiModel(description = "The default value for a multiple version picker custom field.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class CustomFieldContextDefaultValueMultipleVersionPicker {
  @JsonProperty("type")
  private String type;

  @JsonProperty("versionIds")
  private List<String> versionIds = new ArrayList<>();

  @JsonProperty("versionOrder")
  private String versionOrder;

  public CustomFieldContextDefaultValueMultipleVersionPicker type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomFieldContextDefaultValueMultipleVersionPicker versionIds(List<String> versionIds) {
    this.versionIds = versionIds;
    return this;
  }

  public CustomFieldContextDefaultValueMultipleVersionPicker addVersionIdsItem(String versionIdsItem) {
    this.versionIds.add(versionIdsItem);
    return this;
  }

   /**
   * The IDs of the default versions.
   * @return versionIds
  **/
  @ApiModelProperty(required = true, value = "The IDs of the default versions.")
  public List<String> getVersionIds() {
    return versionIds;
  }

  public void setVersionIds(List<String> versionIds) {
    this.versionIds = versionIds;
  }

  public CustomFieldContextDefaultValueMultipleVersionPicker versionOrder(String versionOrder) {
    this.versionOrder = versionOrder;
    return this;
  }

   /**
   * The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are &#x60;\&quot;releasedFirst\&quot;&#x60; and &#x60;\&quot;unreleasedFirst\&quot;&#x60;.
   * @return versionOrder
  **/
  @ApiModelProperty(value = "The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `\"releasedFirst\"` and `\"unreleasedFirst\"`.")
  public String getVersionOrder() {
    return versionOrder;
  }

  public void setVersionOrder(String versionOrder) {
    this.versionOrder = versionOrder;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomFieldContextDefaultValueMultipleVersionPicker customFieldContextDefaultValueMultipleVersionPicker = (CustomFieldContextDefaultValueMultipleVersionPicker) o;
    return Objects.equals(this.type, customFieldContextDefaultValueMultipleVersionPicker.type) &&
        Objects.equals(this.versionIds, customFieldContextDefaultValueMultipleVersionPicker.versionIds) &&
        Objects.equals(this.versionOrder, customFieldContextDefaultValueMultipleVersionPicker.versionOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, versionIds, versionOrder);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomFieldContextDefaultValueMultipleVersionPicker {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    versionIds: ").append(toIndentedString(versionIds)).append("\n");
    sb.append("    versionOrder: ").append(toIndentedString(versionOrder)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

