/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowRuleConfiguration;

/**
 * The conditions group associated with the transition.
 */
@ApiModel(description = "The conditions group associated with the transition.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class ConditionGroupUpdate {
  @JsonProperty("conditionGroups")
  private List<ConditionGroupUpdate> conditionGroups = new ArrayList<>();

  @JsonProperty("conditions")
  private List<WorkflowRuleConfiguration> conditions = new ArrayList<>();

  /**
   * Determines how the conditions in the group are evaluated. Accepts either &#x60;ANY&#x60; or &#x60;ALL&#x60;. If &#x60;ANY&#x60; is used, at least one condition in the group must be true for the group to evaluate to true. If &#x60;ALL&#x60; is used, all conditions in the group must be true for the group to evaluate to true.
   */
  public enum OperationEnum {
    ANY("ANY"),
    
    ALL("ALL");

    private String value;

    OperationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperationEnum fromValue(String value) {
      for (OperationEnum b : OperationEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("operation")
  private OperationEnum operation;

  public ConditionGroupUpdate conditionGroups(List<ConditionGroupUpdate> conditionGroups) {
    this.conditionGroups = conditionGroups;
    return this;
  }

  public ConditionGroupUpdate addConditionGroupsItem(ConditionGroupUpdate conditionGroupsItem) {
    if (this.conditionGroups == null) {
      this.conditionGroups = new ArrayList<>();
    }
    this.conditionGroups.add(conditionGroupsItem);
    return this;
  }

   /**
   * The nested conditions of the condition group.
   * @return conditionGroups
  **/
  @ApiModelProperty(value = "The nested conditions of the condition group.")
  public List<ConditionGroupUpdate> getConditionGroups() {
    return conditionGroups;
  }

  public void setConditionGroups(List<ConditionGroupUpdate> conditionGroups) {
    this.conditionGroups = conditionGroups;
  }

  public ConditionGroupUpdate conditions(List<WorkflowRuleConfiguration> conditions) {
    this.conditions = conditions;
    return this;
  }

  public ConditionGroupUpdate addConditionsItem(WorkflowRuleConfiguration conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

   /**
   * The rules for this condition.
   * @return conditions
  **/
  @ApiModelProperty(value = "The rules for this condition.")
  public List<WorkflowRuleConfiguration> getConditions() {
    return conditions;
  }

  public void setConditions(List<WorkflowRuleConfiguration> conditions) {
    this.conditions = conditions;
  }

  public ConditionGroupUpdate operation(OperationEnum operation) {
    this.operation = operation;
    return this;
  }

   /**
   * Determines how the conditions in the group are evaluated. Accepts either &#x60;ANY&#x60; or &#x60;ALL&#x60;. If &#x60;ANY&#x60; is used, at least one condition in the group must be true for the group to evaluate to true. If &#x60;ALL&#x60; is used, all conditions in the group must be true for the group to evaluate to true.
   * @return operation
  **/
  @ApiModelProperty(required = true, value = "Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.")
  public OperationEnum getOperation() {
    return operation;
  }

  public void setOperation(OperationEnum operation) {
    this.operation = operation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConditionGroupUpdate conditionGroupUpdate = (ConditionGroupUpdate) o;
    return Objects.equals(this.conditionGroups, conditionGroupUpdate.conditionGroups) &&
        Objects.equals(this.conditions, conditionGroupUpdate.conditions) &&
        Objects.equals(this.operation, conditionGroupUpdate.operation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditionGroups, conditions, operation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConditionGroupUpdate {\n");
    
    sb.append("    conditionGroups: ").append(toIndentedString(conditionGroups)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

