/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Announcement banner configuration.
 */
@ApiModel(description = "Announcement banner configuration.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:43.813+01:00[Europe/Prague]")
public class AnnouncementBannerConfiguration {
  @JsonProperty("hashId")
  private String hashId;

  @JsonProperty("isDismissible")
  private Boolean isDismissible;

  @JsonProperty("isEnabled")
  private Boolean isEnabled;

  @JsonProperty("message")
  private String message;

  /**
   * Visibility of the announcement banner.
   */
  public enum VisibilityEnum {
    PUBLIC("PUBLIC"),
    
    PRIVATE("PRIVATE");

    private String value;

    VisibilityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VisibilityEnum fromValue(String value) {
      for (VisibilityEnum b : VisibilityEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("visibility")
  private VisibilityEnum visibility;

   /**
   * Hash of the banner data. The client detects updates by comparing hash IDs.
   * @return hashId
  **/
  @ApiModelProperty(value = "Hash of the banner data. The client detects updates by comparing hash IDs.")
  public String getHashId() {
    return hashId;
  }

   /**
   * Flag indicating if the announcement banner can be dismissed by the user.
   * @return isDismissible
  **/
  @ApiModelProperty(value = "Flag indicating if the announcement banner can be dismissed by the user.")
  public Boolean getIsDismissible() {
    return isDismissible;
  }

   /**
   * Flag indicating if the announcement banner is enabled or not.
   * @return isEnabled
  **/
  @ApiModelProperty(value = "Flag indicating if the announcement banner is enabled or not.")
  public Boolean getIsEnabled() {
    return isEnabled;
  }

   /**
   * The text on the announcement banner.
   * @return message
  **/
  @ApiModelProperty(value = "The text on the announcement banner.")
  public String getMessage() {
    return message;
  }

   /**
   * Visibility of the announcement banner.
   * @return visibility
  **/
  @ApiModelProperty(value = "Visibility of the announcement banner.")
  public VisibilityEnum getVisibility() {
    return visibility;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnnouncementBannerConfiguration announcementBannerConfiguration = (AnnouncementBannerConfiguration) o;
    return Objects.equals(this.hashId, announcementBannerConfiguration.hashId) &&
        Objects.equals(this.isDismissible, announcementBannerConfiguration.isDismissible) &&
        Objects.equals(this.isEnabled, announcementBannerConfiguration.isEnabled) &&
        Objects.equals(this.message, announcementBannerConfiguration.message) &&
        Objects.equals(this.visibility, announcementBannerConfiguration.visibility);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashId, isDismissible, isEnabled, message, visibility);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnnouncementBannerConfiguration {\n");
    
    sb.append("    hashId: ").append(toIndentedString(hashId)).append("\n");
    sb.append("    isDismissible: ").append(toIndentedString(isDismissible)).append("\n");
    sb.append("    isEnabled: ").append(toIndentedString(isEnabled)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

