/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowElementReference;

/**
 * The details about a workflow validation error.
 */
@ApiModel(description = "The details about a workflow validation error.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class WorkflowValidationError {
  @JsonProperty("code")
  private String code;

  @JsonProperty("elementReference")
  private WorkflowElementReference elementReference;

  /**
   * The validation error level.
   */
  public enum LevelEnum {
    WARNING("WARNING"),
    
    ERROR("ERROR");

    private String value;

    LevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LevelEnum fromValue(String value) {
      for (LevelEnum b : LevelEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("level")
  private LevelEnum level;

  @JsonProperty("message")
  private String message;

  /**
   * The type of element the error or warning references.
   */
  public enum TypeEnum {
    RULE("RULE"),
    
    STATUS("STATUS"),
    
    STATUS_LAYOUT("STATUS_LAYOUT"),
    
    STATUS_PROPERTY("STATUS_PROPERTY"),
    
    WORKFLOW("WORKFLOW"),
    
    TRANSITION("TRANSITION"),
    
    TRANSITION_PROPERTY("TRANSITION_PROPERTY"),
    
    SCOPE("SCOPE"),
    
    STATUS_MAPPING("STATUS_MAPPING"),
    
    TRIGGER("TRIGGER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public WorkflowValidationError code(String code) {
    this.code = code;
    return this;
  }

   /**
   * An error code.
   * @return code
  **/
  @ApiModelProperty(value = "An error code.")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public WorkflowValidationError elementReference(WorkflowElementReference elementReference) {
    this.elementReference = elementReference;
    return this;
  }

   /**
   * Get elementReference
   * @return elementReference
  **/
  @ApiModelProperty(value = "")
  public WorkflowElementReference getElementReference() {
    return elementReference;
  }

  public void setElementReference(WorkflowElementReference elementReference) {
    this.elementReference = elementReference;
  }

  public WorkflowValidationError level(LevelEnum level) {
    this.level = level;
    return this;
  }

   /**
   * The validation error level.
   * @return level
  **/
  @ApiModelProperty(value = "The validation error level.")
  public LevelEnum getLevel() {
    return level;
  }

  public void setLevel(LevelEnum level) {
    this.level = level;
  }

  public WorkflowValidationError message(String message) {
    this.message = message;
    return this;
  }

   /**
   * An error message.
   * @return message
  **/
  @ApiModelProperty(value = "An error message.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public WorkflowValidationError type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of element the error or warning references.
   * @return type
  **/
  @ApiModelProperty(value = "The type of element the error or warning references.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowValidationError workflowValidationError = (WorkflowValidationError) o;
    return Objects.equals(this.code, workflowValidationError.code) &&
        Objects.equals(this.elementReference, workflowValidationError.elementReference) &&
        Objects.equals(this.level, workflowValidationError.level) &&
        Objects.equals(this.message, workflowValidationError.message) &&
        Objects.equals(this.type, workflowValidationError.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, elementReference, level, message, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowValidationError {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    elementReference: ").append(toIndentedString(elementReference)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

