/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowTransitionRule;

/**
 * A collection of transition rules.
 */
@ApiModel(description = "A collection of transition rules.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class WorkflowRules {
  @JsonProperty("conditionsTree")
  private Object conditionsTree = null;

  @JsonProperty("postFunctions")
  private List<WorkflowTransitionRule> postFunctions = new ArrayList<>();

  @JsonProperty("validators")
  private List<WorkflowTransitionRule> validators = new ArrayList<>();

  public WorkflowRules conditionsTree(Object conditionsTree) {
    this.conditionsTree = conditionsTree;
    return this;
  }

   /**
   * The workflow transition rule conditions tree.
   * @return conditionsTree
  **/
  @ApiModelProperty(value = "The workflow transition rule conditions tree.")
  public Object getConditionsTree() {
    return conditionsTree;
  }

  public void setConditionsTree(Object conditionsTree) {
    this.conditionsTree = conditionsTree;
  }

  public WorkflowRules postFunctions(List<WorkflowTransitionRule> postFunctions) {
    this.postFunctions = postFunctions;
    return this;
  }

  public WorkflowRules addPostFunctionsItem(WorkflowTransitionRule postFunctionsItem) {
    if (this.postFunctions == null) {
      this.postFunctions = new ArrayList<>();
    }
    this.postFunctions.add(postFunctionsItem);
    return this;
  }

   /**
   * The workflow post functions.
   * @return postFunctions
  **/
  @ApiModelProperty(value = "The workflow post functions.")
  public List<WorkflowTransitionRule> getPostFunctions() {
    return postFunctions;
  }

  public void setPostFunctions(List<WorkflowTransitionRule> postFunctions) {
    this.postFunctions = postFunctions;
  }

  public WorkflowRules validators(List<WorkflowTransitionRule> validators) {
    this.validators = validators;
    return this;
  }

  public WorkflowRules addValidatorsItem(WorkflowTransitionRule validatorsItem) {
    if (this.validators == null) {
      this.validators = new ArrayList<>();
    }
    this.validators.add(validatorsItem);
    return this;
  }

   /**
   * The workflow validators.
   * @return validators
  **/
  @ApiModelProperty(value = "The workflow validators.")
  public List<WorkflowTransitionRule> getValidators() {
    return validators;
  }

  public void setValidators(List<WorkflowTransitionRule> validators) {
    this.validators = validators;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowRules workflowRules = (WorkflowRules) o;
    return Objects.equals(this.conditionsTree, workflowRules.conditionsTree) &&
        Objects.equals(this.postFunctions, workflowRules.postFunctions) &&
        Objects.equals(this.validators, workflowRules.validators);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditionsTree, postFunctions, validators);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowRules {\n");
    
    sb.append("    conditionsTree: ").append(toIndentedString(conditionsTree)).append("\n");
    sb.append("    postFunctions: ").append(toIndentedString(postFunctions)).append("\n");
    sb.append("    validators: ").append(toIndentedString(validators)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

