/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v2.model.SimpleUsage;

/**
 * Workflow metadata and usage detail.
 */
@ApiModel(description = "Workflow metadata and usage detail.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class WorkflowMetadataRestModel {
  @JsonProperty("description")
  private String description;

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("usage")
  private List<SimpleUsage> usage = new ArrayList<>();

  @JsonProperty("version")
  private DocumentVersion version;

  public WorkflowMetadataRestModel description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow.
   * @return description
  **/
  @ApiModelProperty(required = true, value = "The description of the workflow.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WorkflowMetadataRestModel id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the workflow.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The ID of the workflow.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WorkflowMetadataRestModel name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the workflow.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WorkflowMetadataRestModel usage(List<SimpleUsage> usage) {
    this.usage = usage;
    return this;
  }

  public WorkflowMetadataRestModel addUsageItem(SimpleUsage usageItem) {
    this.usage.add(usageItem);
    return this;
  }

   /**
   * Use the optional &#x60;workflows.usages&#x60; expand to get additional information about the projects and issue types associated with the workflows in the workflow scheme.
   * @return usage
  **/
  @ApiModelProperty(required = true, value = "Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the workflows in the workflow scheme.")
  public List<SimpleUsage> getUsage() {
    return usage;
  }

  public void setUsage(List<SimpleUsage> usage) {
    this.usage = usage;
  }

  public WorkflowMetadataRestModel version(DocumentVersion version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(required = true, value = "")
  public DocumentVersion getVersion() {
    return version;
  }

  public void setVersion(DocumentVersion version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowMetadataRestModel workflowMetadataRestModel = (WorkflowMetadataRestModel) o;
    return Objects.equals(this.description, workflowMetadataRestModel.description) &&
        Objects.equals(this.id, workflowMetadataRestModel.id) &&
        Objects.equals(this.name, workflowMetadataRestModel.name) &&
        Objects.equals(this.usage, workflowMetadataRestModel.usage) &&
        Objects.equals(this.version, workflowMetadataRestModel.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, name, usage, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowMetadataRestModel {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    usage: ").append(toIndentedString(usage)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

