/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.WebhookDetails;

/**
 * Details of webhooks to register.
 */
@ApiModel(description = "Details of webhooks to register.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class WebhookRegistrationDetails {
  @JsonProperty("url")
  private String url;

  @JsonProperty("webhooks")
  private List<WebhookDetails> webhooks = new ArrayList<>();

  public WebhookRegistrationDetails url(String url) {
    this.url = url;
    return this;
  }

   /**
   * The URL that specifies where to send the webhooks. This URL must use the same base URL as the Connect app. Only a single URL per app is allowed to be registered.
   * @return url
  **/
  @ApiModelProperty(required = true, value = "The URL that specifies where to send the webhooks. This URL must use the same base URL as the Connect app. Only a single URL per app is allowed to be registered.")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public WebhookRegistrationDetails webhooks(List<WebhookDetails> webhooks) {
    this.webhooks = webhooks;
    return this;
  }

  public WebhookRegistrationDetails addWebhooksItem(WebhookDetails webhooksItem) {
    this.webhooks.add(webhooksItem);
    return this;
  }

   /**
   * A list of webhooks.
   * @return webhooks
  **/
  @ApiModelProperty(required = true, value = "A list of webhooks.")
  public List<WebhookDetails> getWebhooks() {
    return webhooks;
  }

  public void setWebhooks(List<WebhookDetails> webhooks) {
    this.webhooks = webhooks;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookRegistrationDetails webhookRegistrationDetails = (WebhookRegistrationDetails) o;
    return Objects.equals(this.url, webhookRegistrationDetails.url) &&
        Objects.equals(this.webhooks, webhookRegistrationDetails.webhooks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, webhooks);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookRegistrationDetails {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    webhooks: ").append(toIndentedString(webhooks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

