/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * SimplifiedHierarchyLevel
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class SimplifiedHierarchyLevel {
  @JsonProperty("aboveLevelId")
  private Long aboveLevelId;

  @JsonProperty("belowLevelId")
  private Long belowLevelId;

  @JsonProperty("externalUuid")
  private UUID externalUuid;

  @JsonProperty("hierarchyLevelNumber")
  private Integer hierarchyLevelNumber;

  @JsonProperty("id")
  private Long id;

  @JsonProperty("issueTypeIds")
  private List<Long> issueTypeIds = new ArrayList<>();

  @JsonProperty("level")
  private Integer level;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectConfigurationId")
  private Long projectConfigurationId;

  public SimplifiedHierarchyLevel aboveLevelId(Long aboveLevelId) {
    this.aboveLevelId = aboveLevelId;
    return this;
  }

   /**
   * The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return aboveLevelId
  **/
  @ApiModelProperty(value = "The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getAboveLevelId() {
    return aboveLevelId;
  }

  public void setAboveLevelId(Long aboveLevelId) {
    this.aboveLevelId = aboveLevelId;
  }

  public SimplifiedHierarchyLevel belowLevelId(Long belowLevelId) {
    this.belowLevelId = belowLevelId;
    return this;
  }

   /**
   * The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return belowLevelId
  **/
  @ApiModelProperty(value = "The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getBelowLevelId() {
    return belowLevelId;
  }

  public void setBelowLevelId(Long belowLevelId) {
    this.belowLevelId = belowLevelId;
  }

  public SimplifiedHierarchyLevel externalUuid(UUID externalUuid) {
    this.externalUuid = externalUuid;
    return this;
  }

   /**
   * The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return externalUuid
  **/
  @ApiModelProperty(value = "The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public UUID getExternalUuid() {
    return externalUuid;
  }

  public void setExternalUuid(UUID externalUuid) {
    this.externalUuid = externalUuid;
  }

  public SimplifiedHierarchyLevel hierarchyLevelNumber(Integer hierarchyLevelNumber) {
    this.hierarchyLevelNumber = hierarchyLevelNumber;
    return this;
  }

   /**
   * Get hierarchyLevelNumber
   * @return hierarchyLevelNumber
  **/
  @ApiModelProperty(value = "")
  public Integer getHierarchyLevelNumber() {
    return hierarchyLevelNumber;
  }

  public void setHierarchyLevelNumber(Integer hierarchyLevelNumber) {
    this.hierarchyLevelNumber = hierarchyLevelNumber;
  }

  public SimplifiedHierarchyLevel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public SimplifiedHierarchyLevel issueTypeIds(List<Long> issueTypeIds) {
    this.issueTypeIds = issueTypeIds;
    return this;
  }

  public SimplifiedHierarchyLevel addIssueTypeIdsItem(Long issueTypeIdsItem) {
    if (this.issueTypeIds == null) {
      this.issueTypeIds = new ArrayList<>();
    }
    this.issueTypeIds.add(issueTypeIdsItem);
    return this;
  }

   /**
   * The issue types available in this hierarchy level.
   * @return issueTypeIds
  **/
  @ApiModelProperty(value = "The issue types available in this hierarchy level.")
  public List<Long> getIssueTypeIds() {
    return issueTypeIds;
  }

  public void setIssueTypeIds(List<Long> issueTypeIds) {
    this.issueTypeIds = issueTypeIds;
  }

  public SimplifiedHierarchyLevel level(Integer level) {
    this.level = level;
    return this;
  }

   /**
   * The level of this item in the hierarchy.
   * @return level
  **/
  @ApiModelProperty(value = "The level of this item in the hierarchy.")
  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public SimplifiedHierarchyLevel name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of this hierarchy level.
   * @return name
  **/
  @ApiModelProperty(value = "The name of this hierarchy level.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SimplifiedHierarchyLevel projectConfigurationId(Long projectConfigurationId) {
    this.projectConfigurationId = projectConfigurationId;
    return this;
  }

   /**
   * The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return projectConfigurationId
  **/
  @ApiModelProperty(value = "The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getProjectConfigurationId() {
    return projectConfigurationId;
  }

  public void setProjectConfigurationId(Long projectConfigurationId) {
    this.projectConfigurationId = projectConfigurationId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimplifiedHierarchyLevel simplifiedHierarchyLevel = (SimplifiedHierarchyLevel) o;
    return Objects.equals(this.aboveLevelId, simplifiedHierarchyLevel.aboveLevelId) &&
        Objects.equals(this.belowLevelId, simplifiedHierarchyLevel.belowLevelId) &&
        Objects.equals(this.externalUuid, simplifiedHierarchyLevel.externalUuid) &&
        Objects.equals(this.hierarchyLevelNumber, simplifiedHierarchyLevel.hierarchyLevelNumber) &&
        Objects.equals(this.id, simplifiedHierarchyLevel.id) &&
        Objects.equals(this.issueTypeIds, simplifiedHierarchyLevel.issueTypeIds) &&
        Objects.equals(this.level, simplifiedHierarchyLevel.level) &&
        Objects.equals(this.name, simplifiedHierarchyLevel.name) &&
        Objects.equals(this.projectConfigurationId, simplifiedHierarchyLevel.projectConfigurationId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aboveLevelId, belowLevelId, externalUuid, hierarchyLevelNumber, id, issueTypeIds, level, name, projectConfigurationId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimplifiedHierarchyLevel {\n");
    
    sb.append("    aboveLevelId: ").append(toIndentedString(aboveLevelId)).append("\n");
    sb.append("    belowLevelId: ").append(toIndentedString(belowLevelId)).append("\n");
    sb.append("    externalUuid: ").append(toIndentedString(externalUuid)).append("\n");
    sb.append("    hierarchyLevelNumber: ").append(toIndentedString(hierarchyLevelNumber)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issueTypeIds: ").append(toIndentedString(issueTypeIds)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectConfigurationId: ").append(toIndentedString(projectConfigurationId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

