/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Details about an issue security scheme.
 */
@ApiModel(description = "Details about an issue security scheme.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class SecuritySchemeWithProjects {
  @JsonProperty("defaultLevel")
  private Long defaultLevel;

  @JsonProperty("description")
  private String description;

  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectIds")
  private List<Long> projectIds = new ArrayList<>();

  @JsonProperty("self")
  private String self;

  private HashMap<String, Object> additionalProperties_ = new HashMap<String, Object>();

   /**
   * The default level ID of the issue security scheme.
   * @return defaultLevel
  **/
  @ApiModelProperty(value = "The default level ID of the issue security scheme.")
  public Long getDefaultLevel() {
    return defaultLevel;
  }

   /**
   * The description of the issue security scheme.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the issue security scheme.")
  public String getDescription() {
    return description;
  }

   /**
   * The ID of the issue security scheme.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue security scheme.")
  public Long getId() {
    return id;
  }

   /**
   * The name of the issue security scheme.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the issue security scheme.")
  public String getName() {
    return name;
  }

   /**
   * The list of project IDs associated with the issue security scheme.
   * @return projectIds
  **/
  @ApiModelProperty(value = "The list of project IDs associated with the issue security scheme.")
  public List<Long> getProjectIds() {
    return projectIds;
  }

   /**
   * The URL of the issue security scheme.
   * @return self
  **/
  @ApiModelProperty(required = true, value = "The URL of the issue security scheme.")
  public String getSelf() {
    return self;
  }


  @com.fasterxml.jackson.annotation.JsonAnyGetter
  public Map<String, Object> any() {
   return this.additionalProperties_;
  }

  @com.fasterxml.jackson.annotation.JsonAnySetter
  public void set(String name, Object value) {
   this.additionalProperties_.put(name, value);
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecuritySchemeWithProjects securitySchemeWithProjects = (SecuritySchemeWithProjects) o;
    return Objects.equals(this.defaultLevel, securitySchemeWithProjects.defaultLevel) &&
        Objects.equals(this.description, securitySchemeWithProjects.description) &&
        Objects.equals(this.id, securitySchemeWithProjects.id) &&
        Objects.equals(this.name, securitySchemeWithProjects.name) &&
        Objects.equals(this.projectIds, securitySchemeWithProjects.projectIds) &&
        Objects.equals(this.self, securitySchemeWithProjects.self) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultLevel, description, id, name, projectIds, self, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecuritySchemeWithProjects {\n");
    
    sb.append("    defaultLevel: ").append(toIndentedString(defaultLevel)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectIds: ").append(toIndentedString(projectIds)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties_)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

