/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionHolder;

/**
 * Issue security level member.
 */
@ApiModel(description = "Issue security level member.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class SecurityLevelMember {
  @JsonProperty("holder")
  private PermissionHolder holder;

  @JsonProperty("id")
  private String id;

  @JsonProperty("issueSecurityLevelId")
  private String issueSecurityLevelId;

  @JsonProperty("issueSecuritySchemeId")
  private String issueSecuritySchemeId;

  @JsonProperty("managed")
  private Boolean managed;

  private HashMap<String, Object> additionalProperties_ = new HashMap<String, Object>();

   /**
   * The user or group being granted the permission. It consists of a &#x60;type&#x60; and a type-dependent &#x60;parameter&#x60;. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
   * @return holder
  **/
  @ApiModelProperty(required = true, value = "The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.")
  public PermissionHolder getHolder() {
    return holder;
  }

   /**
   * The ID of the issue security level member.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue security level member.")
  public String getId() {
    return id;
  }

   /**
   * The ID of the issue security level.
   * @return issueSecurityLevelId
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue security level.")
  public String getIssueSecurityLevelId() {
    return issueSecurityLevelId;
  }

   /**
   * The ID of the issue security scheme.
   * @return issueSecuritySchemeId
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue security scheme.")
  public String getIssueSecuritySchemeId() {
    return issueSecuritySchemeId;
  }

  public SecurityLevelMember managed(Boolean managed) {
    this.managed = managed;
    return this;
  }

   /**
   * Get managed
   * @return managed
  **/
  @ApiModelProperty(value = "")
  public Boolean getManaged() {
    return managed;
  }

  public void setManaged(Boolean managed) {
    this.managed = managed;
  }


  @com.fasterxml.jackson.annotation.JsonAnyGetter
  public Map<String, Object> any() {
   return this.additionalProperties_;
  }

  @com.fasterxml.jackson.annotation.JsonAnySetter
  public void set(String name, Object value) {
   this.additionalProperties_.put(name, value);
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecurityLevelMember securityLevelMember = (SecurityLevelMember) o;
    return Objects.equals(this.holder, securityLevelMember.holder) &&
        Objects.equals(this.id, securityLevelMember.id) &&
        Objects.equals(this.issueSecurityLevelId, securityLevelMember.issueSecurityLevelId) &&
        Objects.equals(this.issueSecuritySchemeId, securityLevelMember.issueSecuritySchemeId) &&
        Objects.equals(this.managed, securityLevelMember.managed) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(holder, id, issueSecurityLevelId, issueSecuritySchemeId, managed, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecurityLevelMember {\n");
    
    sb.append("    holder: ").append(toIndentedString(holder)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issueSecurityLevelId: ").append(toIndentedString(issueSecurityLevelId)).append("\n");
    sb.append("    issueSecuritySchemeId: ").append(toIndentedString(issueSecuritySchemeId)).append("\n");
    sb.append("    managed: ").append(toIndentedString(managed)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties_)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

