/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.ErrorCollection;

/**
 * Details of the sanitized JQL query.
 */
@ApiModel(description = "Details of the sanitized JQL query.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class SanitizedJqlQuery {
  @JsonProperty("accountId")
  private String accountId;

  @JsonProperty("errors")
  private ErrorCollection errors;

  @JsonProperty("initialQuery")
  private String initialQuery;

  @JsonProperty("sanitizedQuery")
  private String sanitizedQuery;

  public SanitizedJqlQuery accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * The account ID of the user for whom sanitization was performed.
   * @return accountId
  **/
  @ApiModelProperty(value = "The account ID of the user for whom sanitization was performed.")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public SanitizedJqlQuery errors(ErrorCollection errors) {
    this.errors = errors;
    return this;
  }

   /**
   * The list of errors.
   * @return errors
  **/
  @ApiModelProperty(value = "The list of errors.")
  public ErrorCollection getErrors() {
    return errors;
  }

  public void setErrors(ErrorCollection errors) {
    this.errors = errors;
  }

  public SanitizedJqlQuery initialQuery(String initialQuery) {
    this.initialQuery = initialQuery;
    return this;
  }

   /**
   * The initial query.
   * @return initialQuery
  **/
  @ApiModelProperty(value = "The initial query.")
  public String getInitialQuery() {
    return initialQuery;
  }

  public void setInitialQuery(String initialQuery) {
    this.initialQuery = initialQuery;
  }

  public SanitizedJqlQuery sanitizedQuery(String sanitizedQuery) {
    this.sanitizedQuery = sanitizedQuery;
    return this;
  }

   /**
   * The sanitized query, if there were no errors.
   * @return sanitizedQuery
  **/
  @ApiModelProperty(value = "The sanitized query, if there were no errors.")
  public String getSanitizedQuery() {
    return sanitizedQuery;
  }

  public void setSanitizedQuery(String sanitizedQuery) {
    this.sanitizedQuery = sanitizedQuery;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SanitizedJqlQuery sanitizedJqlQuery = (SanitizedJqlQuery) o;
    return Objects.equals(this.accountId, sanitizedJqlQuery.accountId) &&
        Objects.equals(this.errors, sanitizedJqlQuery.errors) &&
        Objects.equals(this.initialQuery, sanitizedJqlQuery.initialQuery) &&
        Objects.equals(this.sanitizedQuery, sanitizedJqlQuery.sanitizedQuery);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, errors, initialQuery, sanitizedQuery);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SanitizedJqlQuery {\n");
    
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    initialQuery: ").append(toIndentedString(initialQuery)).append("\n");
    sb.append("    sanitizedQuery: ").append(toIndentedString(sanitizedQuery)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

