/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.JiraStatus;

/**
 * PageOfStatuses
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class PageOfStatuses {
  @JsonProperty("isLast")
  private Boolean isLast;

  @JsonProperty("maxResults")
  private Integer maxResults;

  @JsonProperty("nextPage")
  private String nextPage;

  @JsonProperty("self")
  private String self;

  @JsonProperty("startAt")
  private Long startAt;

  @JsonProperty("total")
  private Long total;

  @JsonProperty("values")
  private List<JiraStatus> values = new ArrayList<>();

  public PageOfStatuses isLast(Boolean isLast) {
    this.isLast = isLast;
    return this;
  }

   /**
   * Whether this is the last page.
   * @return isLast
  **/
  @ApiModelProperty(value = "Whether this is the last page.")
  public Boolean getIsLast() {
    return isLast;
  }

  public void setIsLast(Boolean isLast) {
    this.isLast = isLast;
  }

  public PageOfStatuses maxResults(Integer maxResults) {
    this.maxResults = maxResults;
    return this;
  }

   /**
   * The maximum number of items that could be returned.
   * @return maxResults
  **/
  @ApiModelProperty(value = "The maximum number of items that could be returned.")
  public Integer getMaxResults() {
    return maxResults;
  }

  public void setMaxResults(Integer maxResults) {
    this.maxResults = maxResults;
  }

  public PageOfStatuses nextPage(String nextPage) {
    this.nextPage = nextPage;
    return this;
  }

   /**
   * The URL of the next page of results, if any.
   * @return nextPage
  **/
  @ApiModelProperty(value = "The URL of the next page of results, if any.")
  public String getNextPage() {
    return nextPage;
  }

  public void setNextPage(String nextPage) {
    this.nextPage = nextPage;
  }

  public PageOfStatuses self(String self) {
    this.self = self;
    return this;
  }

   /**
   * The URL of this page.
   * @return self
  **/
  @ApiModelProperty(value = "The URL of this page.")
  public String getSelf() {
    return self;
  }

  public void setSelf(String self) {
    this.self = self;
  }

  public PageOfStatuses startAt(Long startAt) {
    this.startAt = startAt;
    return this;
  }

   /**
   * The index of the first item returned on the page.
   * @return startAt
  **/
  @ApiModelProperty(value = "The index of the first item returned on the page.")
  public Long getStartAt() {
    return startAt;
  }

  public void setStartAt(Long startAt) {
    this.startAt = startAt;
  }

  public PageOfStatuses total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * Number of items that satisfy the search.
   * @return total
  **/
  @ApiModelProperty(value = "Number of items that satisfy the search.")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  public PageOfStatuses values(List<JiraStatus> values) {
    this.values = values;
    return this;
  }

  public PageOfStatuses addValuesItem(JiraStatus valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * The list of items.
   * @return values
  **/
  @ApiModelProperty(value = "The list of items.")
  public List<JiraStatus> getValues() {
    return values;
  }

  public void setValues(List<JiraStatus> values) {
    this.values = values;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageOfStatuses pageOfStatuses = (PageOfStatuses) o;
    return Objects.equals(this.isLast, pageOfStatuses.isLast) &&
        Objects.equals(this.maxResults, pageOfStatuses.maxResults) &&
        Objects.equals(this.nextPage, pageOfStatuses.nextPage) &&
        Objects.equals(this.self, pageOfStatuses.self) &&
        Objects.equals(this.startAt, pageOfStatuses.startAt) &&
        Objects.equals(this.total, pageOfStatuses.total) &&
        Objects.equals(this.values, pageOfStatuses.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isLast, maxResults, nextPage, self, startAt, total, values);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageOfStatuses {\n");
    
    sb.append("    isLast: ").append(toIndentedString(isLast)).append("\n");
    sb.append("    maxResults: ").append(toIndentedString(maxResults)).append("\n");
    sb.append("    nextPage: ").append(toIndentedString(nextPage)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    startAt: ").append(toIndentedString(startAt)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

