/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowAssociationStatusMapping;

/**
 * The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn&#39;t contain all statuses that the old workflow has. Status mappings can be provided by a combination of &#x60;statusMappingsByWorkflows&#x60; and &#x60;statusMappingsByIssueTypeOverride&#x60;.
 */
@ApiModel(description = "The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class MappingsByWorkflow {
  @JsonProperty("newWorkflowId")
  private String newWorkflowId;

  @JsonProperty("oldWorkflowId")
  private String oldWorkflowId;

  @JsonProperty("statusMappings")
  private List<WorkflowAssociationStatusMapping> statusMappings = new ArrayList<>();

  public MappingsByWorkflow newWorkflowId(String newWorkflowId) {
    this.newWorkflowId = newWorkflowId;
    return this;
  }

   /**
   * The ID of the new workflow.
   * @return newWorkflowId
  **/
  @ApiModelProperty(required = true, value = "The ID of the new workflow.")
  public String getNewWorkflowId() {
    return newWorkflowId;
  }

  public void setNewWorkflowId(String newWorkflowId) {
    this.newWorkflowId = newWorkflowId;
  }

  public MappingsByWorkflow oldWorkflowId(String oldWorkflowId) {
    this.oldWorkflowId = oldWorkflowId;
    return this;
  }

   /**
   * The ID of the old workflow.
   * @return oldWorkflowId
  **/
  @ApiModelProperty(required = true, value = "The ID of the old workflow.")
  public String getOldWorkflowId() {
    return oldWorkflowId;
  }

  public void setOldWorkflowId(String oldWorkflowId) {
    this.oldWorkflowId = oldWorkflowId;
  }

  public MappingsByWorkflow statusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
    this.statusMappings = statusMappings;
    return this;
  }

  public MappingsByWorkflow addStatusMappingsItem(WorkflowAssociationStatusMapping statusMappingsItem) {
    this.statusMappings.add(statusMappingsItem);
    return this;
  }

   /**
   * The list of status mappings.
   * @return statusMappings
  **/
  @ApiModelProperty(required = true, value = "The list of status mappings.")
  public List<WorkflowAssociationStatusMapping> getStatusMappings() {
    return statusMappings;
  }

  public void setStatusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
    this.statusMappings = statusMappings;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MappingsByWorkflow mappingsByWorkflow = (MappingsByWorkflow) o;
    return Objects.equals(this.newWorkflowId, mappingsByWorkflow.newWorkflowId) &&
        Objects.equals(this.oldWorkflowId, mappingsByWorkflow.oldWorkflowId) &&
        Objects.equals(this.statusMappings, mappingsByWorkflow.statusMappings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(newWorkflowId, oldWorkflowId, statusMappings);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MappingsByWorkflow {\n");
    
    sb.append("    newWorkflowId: ").append(toIndentedString(newWorkflowId)).append("\n");
    sb.append("    oldWorkflowId: ").append(toIndentedString(oldWorkflowId)).append("\n");
    sb.append("    statusMappings: ").append(toIndentedString(statusMappings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

