/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.JqlQueryFieldEntityProperty;

/**
 * A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.
 */
@ApiModel(description = "A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class JqlQueryField {
  @JsonProperty("encodedName")
  private String encodedName;

  @JsonProperty("name")
  private String name;

  @JsonProperty("property")
  private List<JqlQueryFieldEntityProperty> property = new ArrayList<>();

  public JqlQueryField encodedName(String encodedName) {
    this.encodedName = encodedName;
    return this;
  }

   /**
   * The encoded name of the field, which can be used directly in a JQL query.
   * @return encodedName
  **/
  @ApiModelProperty(value = "The encoded name of the field, which can be used directly in a JQL query.")
  public String getEncodedName() {
    return encodedName;
  }

  public void setEncodedName(String encodedName) {
    this.encodedName = encodedName;
  }

  public JqlQueryField name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the field.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the field.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JqlQueryField property(List<JqlQueryFieldEntityProperty> property) {
    this.property = property;
    return this;
  }

  public JqlQueryField addPropertyItem(JqlQueryFieldEntityProperty propertyItem) {
    if (this.property == null) {
      this.property = new ArrayList<>();
    }
    this.property.add(propertyItem);
    return this;
  }

   /**
   * When the field refers to a value in an entity property, details of the entity property value.
   * @return property
  **/
  @ApiModelProperty(value = "When the field refers to a value in an entity property, details of the entity property value.")
  public List<JqlQueryFieldEntityProperty> getProperty() {
    return property;
  }

  public void setProperty(List<JqlQueryFieldEntityProperty> property) {
    this.property = property;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JqlQueryField jqlQueryField = (JqlQueryField) o;
    return Objects.equals(this.encodedName, jqlQueryField.encodedName) &&
        Objects.equals(this.name, jqlQueryField.name) &&
        Objects.equals(this.property, jqlQueryField.property);
  }

  @Override
  public int hashCode() {
    return Objects.hash(encodedName, name, property);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JqlQueryField {\n");
    
    sb.append("    encodedName: ").append(toIndentedString(encodedName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    property: ").append(toIndentedString(property)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

