/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectIssueTypes;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowScope;

/**
 * Details of a status.
 */
@ApiModel(description = "Details of a status.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class JiraWorkflowStatus {
  @JsonProperty("description")
  private String description;

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("scope")
  private WorkflowScope scope;

  /**
   * The category of the status.
   */
  public enum StatusCategoryEnum {
    TODO("TODO"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    DONE("DONE");

    private String value;

    StatusCategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusCategoryEnum fromValue(String value) {
      for (StatusCategoryEnum b : StatusCategoryEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("statusCategory")
  private StatusCategoryEnum statusCategory;

  @JsonProperty("statusReference")
  private String statusReference;

  @JsonProperty("usages")
  private List<ProjectIssueTypes> usages = new ArrayList<>();

  public JiraWorkflowStatus description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the status.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the status.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public JiraWorkflowStatus id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the status.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the status.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public JiraWorkflowStatus name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the status.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the status.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JiraWorkflowStatus scope(WorkflowScope scope) {
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  @ApiModelProperty(value = "")
  public WorkflowScope getScope() {
    return scope;
  }

  public void setScope(WorkflowScope scope) {
    this.scope = scope;
  }

  public JiraWorkflowStatus statusCategory(StatusCategoryEnum statusCategory) {
    this.statusCategory = statusCategory;
    return this;
  }

   /**
   * The category of the status.
   * @return statusCategory
  **/
  @ApiModelProperty(value = "The category of the status.")
  public StatusCategoryEnum getStatusCategory() {
    return statusCategory;
  }

  public void setStatusCategory(StatusCategoryEnum statusCategory) {
    this.statusCategory = statusCategory;
  }

  public JiraWorkflowStatus statusReference(String statusReference) {
    this.statusReference = statusReference;
    return this;
  }

   /**
   * The reference of the status.
   * @return statusReference
  **/
  @ApiModelProperty(value = "The reference of the status.")
  public String getStatusReference() {
    return statusReference;
  }

  public void setStatusReference(String statusReference) {
    this.statusReference = statusReference;
  }

  public JiraWorkflowStatus usages(List<ProjectIssueTypes> usages) {
    this.usages = usages;
    return this;
  }

  public JiraWorkflowStatus addUsagesItem(ProjectIssueTypes usagesItem) {
    if (this.usages == null) {
      this.usages = new ArrayList<>();
    }
    this.usages.add(usagesItem);
    return this;
  }

   /**
   * The &#x60;statuses.usages&#x60; expand is an optional parameter that can be used when reading and updating statuses in Jira. It provides additional information about the projects and issue types associated with the requested statuses.
   * @return usages
  **/
  @ApiModelProperty(value = "The `statuses.usages` expand is an optional parameter that can be used when reading and updating statuses in Jira. It provides additional information about the projects and issue types associated with the requested statuses.")
  public List<ProjectIssueTypes> getUsages() {
    return usages;
  }

  public void setUsages(List<ProjectIssueTypes> usages) {
    this.usages = usages;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JiraWorkflowStatus jiraWorkflowStatus = (JiraWorkflowStatus) o;
    return Objects.equals(this.description, jiraWorkflowStatus.description) &&
        Objects.equals(this.id, jiraWorkflowStatus.id) &&
        Objects.equals(this.name, jiraWorkflowStatus.name) &&
        Objects.equals(this.scope, jiraWorkflowStatus.scope) &&
        Objects.equals(this.statusCategory, jiraWorkflowStatus.statusCategory) &&
        Objects.equals(this.statusReference, jiraWorkflowStatus.statusReference) &&
        Objects.equals(this.usages, jiraWorkflowStatus.usages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, name, scope, statusCategory, statusReference, usages);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JiraWorkflowStatus {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    statusCategory: ").append(toIndentedString(statusCategory)).append("\n");
    sb.append("    statusReference: ").append(toIndentedString(statusReference)).append("\n");
    sb.append("    usages: ").append(toIndentedString(usages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

