/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.FilterSubscriptionsList;
import org.everit.atlassian.restclient.jiracloud.v2.model.SharePermission;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserList;

/**
 * Details about a filter.
 */
@ApiModel(description = "Details about a filter.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class Filter {
  @JsonProperty("description")
  private String description;

  @JsonProperty("editPermissions")
  private List<SharePermission> editPermissions = new ArrayList<>();

  @JsonProperty("favourite")
  private Boolean favourite;

  @JsonProperty("favouritedCount")
  private Long favouritedCount;

  @JsonProperty("id")
  private String id;

  @JsonProperty("jql")
  private String jql;

  @JsonProperty("name")
  private String name;

  @JsonProperty("owner")
  private User owner;

  @JsonProperty("searchUrl")
  private URI searchUrl;

  @JsonProperty("self")
  private URI self;

  @JsonProperty("sharePermissions")
  private List<SharePermission> sharePermissions = new ArrayList<>();

  @JsonProperty("sharedUsers")
  private UserList sharedUsers;

  @JsonProperty("subscriptions")
  private FilterSubscriptionsList subscriptions;

  @JsonProperty("viewUrl")
  private URI viewUrl;

  public Filter description(String description) {
    this.description = description;
    return this;
  }

   /**
   * A description of the filter.
   * @return description
  **/
  @ApiModelProperty(value = "A description of the filter.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Filter editPermissions(List<SharePermission> editPermissions) {
    this.editPermissions = editPermissions;
    return this;
  }

  public Filter addEditPermissionsItem(SharePermission editPermissionsItem) {
    if (this.editPermissions == null) {
      this.editPermissions = new ArrayList<>();
    }
    this.editPermissions.add(editPermissionsItem);
    return this;
  }

   /**
   * The groups and projects that can edit the filter.
   * @return editPermissions
  **/
  @ApiModelProperty(value = "The groups and projects that can edit the filter.")
  public List<SharePermission> getEditPermissions() {
    return editPermissions;
  }

  public void setEditPermissions(List<SharePermission> editPermissions) {
    this.editPermissions = editPermissions;
  }

  public Filter favourite(Boolean favourite) {
    this.favourite = favourite;
    return this;
  }

   /**
   * Whether the filter is selected as a favorite.
   * @return favourite
  **/
  @ApiModelProperty(value = "Whether the filter is selected as a favorite.")
  public Boolean getFavourite() {
    return favourite;
  }

  public void setFavourite(Boolean favourite) {
    this.favourite = favourite;
  }

   /**
   * The count of how many users have selected this filter as a favorite, including the filter owner.
   * @return favouritedCount
  **/
  @ApiModelProperty(value = "The count of how many users have selected this filter as a favorite, including the filter owner.")
  public Long getFavouritedCount() {
    return favouritedCount;
  }

   /**
   * The unique identifier for the filter.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier for the filter.")
  public String getId() {
    return id;
  }

  public Filter jql(String jql) {
    this.jql = jql;
    return this;
  }

   /**
   * The JQL query for the filter. For example, *project &#x3D; SSP AND issuetype &#x3D; Bug*.
   * @return jql
  **/
  @ApiModelProperty(value = "The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.")
  public String getJql() {
    return jql;
  }

  public void setJql(String jql) {
    this.jql = jql;
  }

  public Filter name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the filter. Must be unique.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the filter. Must be unique.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

   /**
   * The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.
   * @return owner
  **/
  @ApiModelProperty(value = "The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.")
  public User getOwner() {
    return owner;
  }

   /**
   * A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-2-filter-search-get) operation with the filter&#39;s JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/2/search?jql&#x3D;project+%3D+SSP+AND+issuetype+%3D+Bug*.
   * @return searchUrl
  **/
  @ApiModelProperty(value = "A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-2-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/2/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.")
  public URI getSearchUrl() {
    return searchUrl;
  }

   /**
   * The URL of the filter.
   * @return self
  **/
  @ApiModelProperty(value = "The URL of the filter.")
  public URI getSelf() {
    return self;
  }

  public Filter sharePermissions(List<SharePermission> sharePermissions) {
    this.sharePermissions = sharePermissions;
    return this;
  }

  public Filter addSharePermissionsItem(SharePermission sharePermissionsItem) {
    if (this.sharePermissions == null) {
      this.sharePermissions = new ArrayList<>();
    }
    this.sharePermissions.add(sharePermissionsItem);
    return this;
  }

   /**
   * The groups and projects that the filter is shared with.
   * @return sharePermissions
  **/
  @ApiModelProperty(value = "The groups and projects that the filter is shared with.")
  public List<SharePermission> getSharePermissions() {
    return sharePermissions;
  }

  public void setSharePermissions(List<SharePermission> sharePermissions) {
    this.sharePermissions = sharePermissions;
  }

   /**
   * A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.
   * @return sharedUsers
  **/
  @ApiModelProperty(value = "A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.")
  public UserList getSharedUsers() {
    return sharedUsers;
  }

   /**
   * A paginated list of the users that are subscribed to the filter.
   * @return subscriptions
  **/
  @ApiModelProperty(value = "A paginated list of the users that are subscribed to the filter.")
  public FilterSubscriptionsList getSubscriptions() {
    return subscriptions;
  }

   /**
   * A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter&#x3D;10100*.
   * @return viewUrl
  **/
  @ApiModelProperty(value = "A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.")
  public URI getViewUrl() {
    return viewUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Filter filter = (Filter) o;
    return Objects.equals(this.description, filter.description) &&
        Objects.equals(this.editPermissions, filter.editPermissions) &&
        Objects.equals(this.favourite, filter.favourite) &&
        Objects.equals(this.favouritedCount, filter.favouritedCount) &&
        Objects.equals(this.id, filter.id) &&
        Objects.equals(this.jql, filter.jql) &&
        Objects.equals(this.name, filter.name) &&
        Objects.equals(this.owner, filter.owner) &&
        Objects.equals(this.searchUrl, filter.searchUrl) &&
        Objects.equals(this.self, filter.self) &&
        Objects.equals(this.sharePermissions, filter.sharePermissions) &&
        Objects.equals(this.sharedUsers, filter.sharedUsers) &&
        Objects.equals(this.subscriptions, filter.subscriptions) &&
        Objects.equals(this.viewUrl, filter.viewUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, editPermissions, favourite, favouritedCount, id, jql, name, owner, searchUrl, self, sharePermissions, sharedUsers, subscriptions, viewUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Filter {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    editPermissions: ").append(toIndentedString(editPermissions)).append("\n");
    sb.append("    favourite: ").append(toIndentedString(favourite)).append("\n");
    sb.append("    favouritedCount: ").append(toIndentedString(favouritedCount)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    jql: ").append(toIndentedString(jql)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    searchUrl: ").append(toIndentedString(searchUrl)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    sharePermissions: ").append(toIndentedString(sharePermissions)).append("\n");
    sb.append("    sharedUsers: ").append(toIndentedString(sharedUsers)).append("\n");
    sb.append("    subscriptions: ").append(toIndentedString(subscriptions)).append("\n");
    sb.append("    viewUrl: ").append(toIndentedString(viewUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

