/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * List issues archived within a specified date range.
 */
@ApiModel(description = "List issues archived within a specified date range.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class DateRangeFilterRequest {
  @JsonProperty("dateAfter")
  private String dateAfter;

  @JsonProperty("dateBefore")
  private String dateBefore;

  public DateRangeFilterRequest dateAfter(String dateAfter) {
    this.dateAfter = dateAfter;
    return this;
  }

   /**
   * List issues archived after a specified date, passed in the YYYY-MM-DD format.
   * @return dateAfter
  **/
  @ApiModelProperty(required = true, value = "List issues archived after a specified date, passed in the YYYY-MM-DD format.")
  public String getDateAfter() {
    return dateAfter;
  }

  public void setDateAfter(String dateAfter) {
    this.dateAfter = dateAfter;
  }

  public DateRangeFilterRequest dateBefore(String dateBefore) {
    this.dateBefore = dateBefore;
    return this;
  }

   /**
   * List issues archived before a specified date provided in the YYYY-MM-DD format.
   * @return dateBefore
  **/
  @ApiModelProperty(required = true, value = "List issues archived before a specified date provided in the YYYY-MM-DD format.")
  public String getDateBefore() {
    return dateBefore;
  }

  public void setDateBefore(String dateBefore) {
    this.dateBefore = dateBefore;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DateRangeFilterRequest dateRangeFilterRequest = (DateRangeFilterRequest) o;
    return Objects.equals(this.dateAfter, dateRangeFilterRequest.dateAfter) &&
        Objects.equals(this.dateBefore, dateRangeFilterRequest.dateBefore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateAfter, dateBefore);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DateRangeFilterRequest {\n");
    
    sb.append("    dateAfter: ").append(toIndentedString(dateAfter)).append("\n");
    sb.append("    dateBefore: ").append(toIndentedString(dateBefore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

