/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.NestedResponse;

/**
 * Details about a created issue or subtask.
 */
@ApiModel(description = "Details about a created issue or subtask.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class CreatedIssue {
  @JsonProperty("id")
  private String id;

  @JsonProperty("key")
  private String key;

  @JsonProperty("self")
  private String self;

  @JsonProperty("transition")
  private NestedResponse transition;

  @JsonProperty("watchers")
  private NestedResponse watchers;

   /**
   * The ID of the created issue or subtask.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the created issue or subtask.")
  public String getId() {
    return id;
  }

   /**
   * The key of the created issue or subtask.
   * @return key
  **/
  @ApiModelProperty(value = "The key of the created issue or subtask.")
  public String getKey() {
    return key;
  }

   /**
   * The URL of the created issue or subtask.
   * @return self
  **/
  @ApiModelProperty(value = "The URL of the created issue or subtask.")
  public String getSelf() {
    return self;
  }

   /**
   * The response code and messages related to any requested transition.
   * @return transition
  **/
  @ApiModelProperty(value = "The response code and messages related to any requested transition.")
  public NestedResponse getTransition() {
    return transition;
  }

   /**
   * The response code and messages related to any requested watchers.
   * @return watchers
  **/
  @ApiModelProperty(value = "The response code and messages related to any requested watchers.")
  public NestedResponse getWatchers() {
    return watchers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatedIssue createdIssue = (CreatedIssue) o;
    return Objects.equals(this.id, createdIssue.id) &&
        Objects.equals(this.key, createdIssue.key) &&
        Objects.equals(this.self, createdIssue.self) &&
        Objects.equals(this.transition, createdIssue.transition) &&
        Objects.equals(this.watchers, createdIssue.watchers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, self, transition, watchers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatedIssue {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    transition: ").append(toIndentedString(transition)).append("\n");
    sb.append("    watchers: ").append(toIndentedString(watchers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

