/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateWorkflowTransitionRulesDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreateWorkflowTransitionScreenDetails;

/**
 * The details of a workflow transition.
 */
@ApiModel(description = "The details of a workflow transition.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-13T15:26:36.903+01:00[Europe/Prague]")
public class CreateWorkflowTransitionDetails {
  @JsonProperty("description")
  private String description;

  @JsonProperty("from")
  private List<String> from = new ArrayList<>();

  @JsonProperty("name")
  private String name;

  @JsonProperty("properties")
  private Map<String, String> properties = new HashMap<>();

  @JsonProperty("rules")
  private CreateWorkflowTransitionRulesDetails rules;

  @JsonProperty("screen")
  private CreateWorkflowTransitionScreenDetails screen;

  @JsonProperty("to")
  private String to;

  /**
   * The type of the transition.
   */
  public enum TypeEnum {
    GLOBAL("global"),
    
    INITIAL("initial"),
    
    DIRECTED("directed");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public CreateWorkflowTransitionDetails description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the transition. The maximum length is 1000 characters.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the transition. The maximum length is 1000 characters.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CreateWorkflowTransitionDetails from(List<String> from) {
    this.from = from;
    return this;
  }

  public CreateWorkflowTransitionDetails addFromItem(String fromItem) {
    if (this.from == null) {
      this.from = new ArrayList<>();
    }
    this.from.add(fromItem);
    return this;
  }

   /**
   * The statuses the transition can start from.
   * @return from
  **/
  @ApiModelProperty(value = "The statuses the transition can start from.")
  public List<String> getFrom() {
    return from;
  }

  public void setFrom(List<String> from) {
    this.from = from;
  }

  public CreateWorkflowTransitionDetails name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the transition. The maximum length is 60 characters.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the transition. The maximum length is 60 characters.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CreateWorkflowTransitionDetails properties(Map<String, String> properties) {
    this.properties = properties;
    return this;
  }

  public CreateWorkflowTransitionDetails putPropertiesItem(String key, String propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * The properties of the transition.
   * @return properties
  **/
  @ApiModelProperty(value = "The properties of the transition.")
  public Map<String, String> getProperties() {
    return properties;
  }

  public void setProperties(Map<String, String> properties) {
    this.properties = properties;
  }

  public CreateWorkflowTransitionDetails rules(CreateWorkflowTransitionRulesDetails rules) {
    this.rules = rules;
    return this;
  }

   /**
   * The rules of the transition.
   * @return rules
  **/
  @ApiModelProperty(value = "The rules of the transition.")
  public CreateWorkflowTransitionRulesDetails getRules() {
    return rules;
  }

  public void setRules(CreateWorkflowTransitionRulesDetails rules) {
    this.rules = rules;
  }

  public CreateWorkflowTransitionDetails screen(CreateWorkflowTransitionScreenDetails screen) {
    this.screen = screen;
    return this;
  }

   /**
   * The screen of the transition.
   * @return screen
  **/
  @ApiModelProperty(value = "The screen of the transition.")
  public CreateWorkflowTransitionScreenDetails getScreen() {
    return screen;
  }

  public void setScreen(CreateWorkflowTransitionScreenDetails screen) {
    this.screen = screen;
  }

  public CreateWorkflowTransitionDetails to(String to) {
    this.to = to;
    return this;
  }

   /**
   * The status the transition goes to.
   * @return to
  **/
  @ApiModelProperty(required = true, value = "The status the transition goes to.")
  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }

  public CreateWorkflowTransitionDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the transition.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The type of the transition.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWorkflowTransitionDetails createWorkflowTransitionDetails = (CreateWorkflowTransitionDetails) o;
    return Objects.equals(this.description, createWorkflowTransitionDetails.description) &&
        Objects.equals(this.from, createWorkflowTransitionDetails.from) &&
        Objects.equals(this.name, createWorkflowTransitionDetails.name) &&
        Objects.equals(this.properties, createWorkflowTransitionDetails.properties) &&
        Objects.equals(this.rules, createWorkflowTransitionDetails.rules) &&
        Objects.equals(this.screen, createWorkflowTransitionDetails.screen) &&
        Objects.equals(this.to, createWorkflowTransitionDetails.to) &&
        Objects.equals(this.type, createWorkflowTransitionDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, from, name, properties, rules, screen, to, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWorkflowTransitionDetails {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    screen: ").append(toIndentedString(screen)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

